<%@ Control Language="C#" EnableTheming="false"  AutoEventWireup="false" Inherits="EnjooSite.Web.UI.Controls.PostComment" %>
<%@ Register TagPrefix="sub" Namespace="EnjooSite.Web.Controls" Assembly="EnjooSite.Web.Controls" %>
<%@ Register TagPrefix="sub" Namespace="EnjooSite.Web.Controls.Captcha" Assembly="EnjooSite.Web.Controls" %>

<div id="CommentForm">
    <h2>Post a comment</h2>
    <fieldset>
        <legend></legend>
        <p>
            <label for="PostComment_ascx_tbTitle" accesskey="T">
                <u>T</u>itle:</label>
            <asp:TextBox ID="tbTitle" runat="server" Size="40" TabIndex="1" CssClass="textbox" />
            <br />
            <asp:RequiredFieldValidator ID="vldTitleRequired" runat="server" ErrorMessage="Please enter a title"
                ControlToValidate="tbTitle" Display="Dynamic" EnableClientScript="true" />
        </p>
        <p>
            <label for="PostComment_ascx_tbName" accesskey="N">
                <u>N</u>ame:</label>
            <asp:TextBox ID="tbName" runat="server" Size="40" TabIndex="2" CssClass="textbox" />
            <br />
            <asp:RequiredFieldValidator ID="vldNameRequired" runat="server" ErrorMessage="Please enter your name"
                ControlToValidate="tbName" Display="Dynamic" EnableClientScript="true" />
        </p>
        <p>
            <label for="PostComment_ascx_tbEmail" accesskey="E">
                <u>E</u>mail: <em>Not Displayed</em></label>
            <asp:TextBox ID="tbEmail" runat="server" Size="40" TabIndex="2" CssClass="textbox" />
            <br />
            <asp:RegularExpressionValidator ID="vldEmail" runat="server" ControlToValidate="tbEmail"
                ValidationExpression="^.*?@.+\..+$" Display="dynamic" ErrorMessage="Email is not required, but it must be valid if specified."
                EnableClientScript="true" />
        </p>
        <p>
            <label for="PostComment_ascx_tbUrl" accesskey="W">
                <u>W</u>ebsite:</label>
            <asp:TextBox ID="tbUrl" runat="server" Size="40" TabIndex="3" CssClass="textbox" />
            <asp:RegularExpressionValidator ID="vldUrl" runat="server" ControlToValidate="tbUrl"
                ValidationExpression="^(https?://)?([\w-]+\.)+[\w-]+([\w-./?%&=:]*)?$" Display="dynamic"
                ErrorMessage="Url is not required, but it must be valid if specified." EnableClientScript="true" />
        </p>
        <p>
            <label for="PostComment_ascx_tbComment" accesskey="C">
                <u>C</u>omment:</label>
            <asp:TextBox ID="tbComment" runat="server" Rows="10" Columns="50" TabIndex="4" CssClass="textarea"
                TextMode="MultiLine" />
            <br />
            <asp:RequiredFieldValidator ID="vldCommentBody" runat="server" ErrorMessage="Please enter a comment"
                ControlToValidate="tbComment" EnableClientScript="true" />
        </p>
        <asp:CheckBox ID="chkRemember" runat="server" Text="Remember Me?" Visible="False"
            TabIndex="5" />
        <p>
            <sub:EnjooSiteCaptchaControl ID="captcha" runat="server" CssClass="captcha"  ErrorMessage="Please enter the correct word" />
            
            <sub:CompliantButton ID="btnCompliantSubmit" CssClass="buttonSubmit" runat="server" Text="Post" TabIndex="6" CausesValidation="true" />
            <asp:Label ID="Message" runat="server" ForeColor="Red" />
        </p>
        <div id="stylesheetTest">
        </div>
    </fieldset>
</div>

