<%@ Control Language="C#" EnableTheming="false"  Inherits="EnjooSite.Web.UI.Controls.ViewPost" %>
<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="EnjooSite.Framework.Web.HttpModules" %>
<%@ Register TagPrefix="uc1" TagName="PreviousNext" Src="PreviousNext.ascx" %>
<%@ Register TagPrefix="uc1" TagName="CategoryList" Src="CategoryList.ascx" %>
<%@ Register TagPrefix="uc1" TagName="PostComments" Src="PostComment.ascx" %>
<%@ Register TagPrefix="uc1" TagName="PostVote" Src="PostVote.ascx" %>
<%@ Register TagPrefix="uc1" TagName="Comments" Src="Comments.ascx" %>
<%@ Register TagPrefix="uc1" TagName="MyLinks" Src="MyLinks.ascx" %>
<%@ Register TagPrefix="uc1" TagName="PostScore" Src="PostScore.ascx" %>
<%@ Register TagPrefix="uc1" TagName="PostRatings" Src="PostRatings.ascx" %>
<%@ Register TagPrefix="uc1" TagName="PostViewers" Src="PostViewers.ascx" %>
<%@ Register TagPrefix="uc1" TagName="PostRelatedPersonTags" Src="PostRelatedPersonTags.ascx" %>
<%@ Register TagPrefix="uc1" TagName="PostRelatedSystemTags" Src="PostRelatedSystemTags.ascx" %>
<%@ Register TagPrefix="enjoo" TagName="PostRelatedPosts" Src="PostRelatedPosts.ascx" %>
<%@ Register TagPrefix="enjoo" TagName="ViewPostVote" Src="ViewPostVote.ascx" %>
<%@ Register TagPrefix="enjoo" TagName="PostDebated" Src="PostDebated.ascx" %>
<%@ Register TagPrefix="enjoo" TagName="PostQuestion" Src="PostQuestion.ascx" %>
<%@ Register TagPrefix="enjoo" TagName="PostAttachFiles" Src="PostAttachFiles.ascx" %>
<%@ Register TagPrefix="uc1" TagName="PostCategoryList" Src="PostCategoryList.ascx" %>
<%@ Register TagPrefix="uc1" TagName="News" Src="News.ascx" %>

<asp:ScriptManagerProxy ID="ScriptManagerProxy1" runat="server"></asp:ScriptManagerProxy>

<div class="grid_8 content_container">
    <div class="inner_box">
        
        <uc1:PostScore ID="PostScore1" runat="server" />
        
        <div class="simply_box">
            <h3><asp:HyperLink runat="server" ID="editLink" /><asp:HyperLink CssClass="singleposttitle" runat="server" ID="TitleUrl" /></h3>
            <div class="postfooter"><asp:Literal ID="PostDescription" runat="server" /></div>
            <div class="journal_content">
                <asp:Literal ID="Body" runat="server" />
            </div>
            <uc1:PostCategoryList id="Categories" runat="server"></uc1:PostCategoryList>
            <div class="hSpace_10"></div>
            <p class="enclosure" style="display:none;"><asp:Label ID="Enclosure" runat="server" DisplaySize="True" /></p>
            
            <% if (CurrentEntry.Vote != null)
               { %>
                <div class="post_vote_container simply_box clearfix">
                    <enjoo:ViewPostVote ID="ViewPostVote1" runat="server" />
                </div>
                <div class="hSpace_10"></div>
              <% } %>
              
            <enjoo:PostDebated ID="PostDebated1" runat="server" />
        </div>
        <div class="hSpace_10"></div>
        
        <% if (CurrentEntry.Question != null)
           { %>
            <div id="postQuestionContainer" class="enjoo_box_container">
                <enjoo:PostQuestion ID="PostQuestion1" runat="server" />
            </div>
            <div class="hSpace_10"></div>
        <% } %>
        
        <% if ( SecurityHelper.IsAdmin==true || CurrentEntry.AllowComments == true)
           {  %>
            <div id="postCommentsContainer" class="enjoo_box_container">
                <uc1:Comments ID="Comments1" runat="server" />  
            </div>
            <div class="hSpace_10"></div>    
        <% } %>
        <asp:Literal ID="TrackBack" runat="server" />
        
        <% if (Config.CurrentLoginer != null && CurrentEntry.CommentingClosed == false )
           { %>
            <div id="CommentForm" class="enjoo_box_container">
                <h5><%= UIText.GetSafeText("SiteMenu", "Label_PostFeedback_Text", string.Empty)%></h5>
                <ul class="v_list enjoo_box_content">
                    <li>
                        <input type="text" id="commentTitleTextBox" size="40" maxlength="128" class="simply_text"  style="width:342px;"/>                    
                    </li>
                    <li>
                        <div id="commentBodyContainer" style="width:350px;"></div>
                    </li>
                    <li>
                        <input id="saveCommentButton" type="button" class="submit_button" value="ȷ" />
                    </li>
                </ul>
                <script type="text/javascript">
                    var currentFCKEditorInstanceId = 'PostComment';
                    $(function(e) {
                        $("#commentTitleTextBox").val("RE:" + $('<%= String.Format("#{0}", TitleUrl.ClientID) %>').text());
                        var fckeditorID = 'PostComment_richTextEditor';
                        var basePath = '<%= HttpHelper.ExpandTildePath("~/Providers/BlogEntryEditor/fckeditor2/") %>';
                        var toolbarSet = "Mini";
                        initFCKeditor(fckeditorID, basePath, toolbarSet, "commentBodyContainer");
                        $("#saveCommentButton").bind("click", { sender: $("#saveCommentButton"), titleTextBox: $("#commentTitleTextBox"), fckeditorID: fckeditorID }, savePostComment);
                    });
                </script>
            </div>
        <% } %>
    </div>
</div>

<div class="grid_4 content_sidebar">
    <div class="inner_box">
    
        <uc1:MyLinks ID="MyLinks" runat="server" Visible="false" />
        
        <div class="enjoo_ad_s1">
            <%= Config.SystemSettings.AD_PostPage %>
        </div>    
        <div class="hSpace_10"></div>
        
        <uc1:News ID="News1" runat="server" />   
        <div class="hSpace_10"></div>
        
        <% if( CurrentEntry.AttachFiles.Count > 0 ){ %>
        <enjoo:PostAttachFiles ID="PostAttachFiles1" runat="server" />
        <div class="hSpace_10"></div>
        <% } %>
        <uc1:PostRelatedPersonTags id="PostRelatedPersonTags1" runat="server" />
        <enjoo:PostRelatedPosts ID="PostRelatedByPersonTagPosts" runat="server" IsSystemTag="false" />
        <div class="hSpace_10"></div>
        
        <uc1:PostRelatedSystemTags id="PostRelatedSystemTags1" IsSystemTag="true" runat="server" />    
        <enjoo:PostRelatedPosts ID="PostRelatedBySystemTagPosts" runat="server" IsSystemTag="true" />    
        <div class="hSpace_10"></div>
        
        <uc1:PostRatings id="PostRatings1" runat="server" />
        <div class="hSpace_10"></div>
              
        <uc1:PostViewers ID="PostViewers1" runat="server" />
        <div class="hSpace_10"></div>
        
        <uc1:CategoryList ID="CategoryList1" runat="server" />
        <div class="hSpace_10"></div>
        
    </div>
</div>

<div class="clear"></div>