<%@ Control Language="C#" EnableTheming="false"  Inherits="EnjooSite.Web.UI.Controls.Site.EntryList" %>
<%@ Register TagName="TagList" TagPrefix="uc1" Src="TagList.ascx" %>
<%@ Import Namespace = "EnjooSite.Framework" %>
<%@ Import Namespace="EnjooSite.Web.UI" %>

<asp:Repeater ID="Entries" Runat="server" OnItemCreated="PostCreated">
	<ItemTemplate>
        <div class="postContainer">
            <div class="postBody">
                <h5 class="postHeader">
                    <asp:HyperLink runat="server" ID="TitleUrl" Target="_blank" />
                </h5>
                <div class="postMain clearfix">
                    <asp:Image ID="PostLogoImage" runat="server" BorderWidth="2" Visible="false" />             
                    <asp:Literal ID="PostText" runat="server" />
                </div>
                <div class="postFooter">
                    <asp:Literal id="PosterLiteral" runat="server"></asp:Literal>
                    <%= UIText.GetSafeText("VSite", "Label_Posted_Text", string.Empty)%>
                    <asp:HyperLink ID="PostedDateLink" runat="server"></asp:HyperLink>
                    <span class="tool comments">
                        <asp:Literal ID="PostDesc" runat="server" />
                    </span>
                    <uc1:TagList id="TagList1" runat="server"></uc1:TagList>
                </div>
            </div>
        </div>
	</ItemTemplate>	
</asp:Repeater>
<div class="hSpace_10"></div>
<div class="pagerContainer pager">
    <st:AspNetPager ID="AspNetPager1" CurrentPageButtonStyle="color:#fff" UrlPaging="true" EnableUrlRewriting="true" runat="server" OnPageChanged="AspNetPager1_PageChanged" ></st:AspNetPager>
</div>
<div class="hSpace_10"></div>