<%@ Control  %>
<%@ Import Namespace="EnjooSite.Web.UI" %>
<%@ Register TagName="TagsList" TagPrefix="uc1" Src="TagsList.ascx" %>
<%@ Register TagName="SystemTagsCloud" TagPrefix="uc1" Src="SystemTagsCloud.ascx" %>
<%@ Register TagName="Footer" TagPrefix="asp" Src="Footer.ascx" %>
<%@ Register TagName="SystemToolbar" TagPrefix="asp" Src="SystemToolbar.ascx" %>
<%@ Register TagPrefix="uc1" TagName="ChannelEntryList" Src="ChannelEntryList.ascx" %>
<%@ Register TagPrefix="uc1" TagName="ChannelHeader" Src="ChannelHeader.ascx" %>
<%@ Register TagPrefix="uc1" TagName="StoryCategoryList" Src="VStoryCategoryList.ascx" %>
<%@ Register TagPrefix="uc1" TagName="TopEntryList" Src="TopEntryList.ascx" %>



<div id="siteWrapper">
    <div class="container_12">
    
        <div id="header" class="grid_12">
            <h1><a href='<%= VirtualPathUtility.ToAbsolute("~/") %>' title='<%= Config.WebTitle %>'><span><%= Config.WebTitle %></span></a></h1>
            <h2><span><%= Config.WebDescription %></span></h2>
        </div>
        
    <div id="pageContent">
        <div id="column1"  class="grid_7">
            <uc1:ChannelHeader ID="ChannelHeader1" runat="server" />
            <uc1:ChannelEntryList ID="EntryList1" DescriptionOnly="true" WordLimit="100" LengthLimit="600" runat="server" />
        </div>
        <div id="column2" class="grid_5">
            <div class="innerBox">
            
                <% if( !string.IsNullOrEmpty(Config.CurrentChannel.MainBanner)){ %>
                    <div class="tab clearfix">
                        <h3>
                            <%= UIText.GetSafeText("VSite","Label_ChannelMessage_Text",string.Empty ) %>
                        </h3>
                    </div>
                    <div class="tab-details">
                        <%= Config.CurrentChannel.MainBanner %>
                    </div>
                    <div class="hSpace_10"></div>
                <% } %>
                
                <% if( !string.IsNullOrEmpty(Config.CurrentChannel.Description)){ %>
                    <div class="tab clearfix">
                        <h3>
                            <%= UIText.GetSafeText("VSite","Label_ChannelDescription_Text",string.Empty ) %>
                        </h3>
                    </div>
                    <div class="tab-details">
                        <%= Config.CurrentChannel.Description %>
                    </div>
                    <div class="hSpace_10"></div>
                <% } %>
                
                <div class="tab clearfix">
                    <h3>
                        <%= UIText.GetSafeText("VSite","Label_TopPosts_Text",string.Empty ) %>
                    </h3>
                </div>
                <div class="tab-details">
                    <uc1:TopEntryList ID="TopEntryList1" runat="server" TopCount="10" />  
                </div>
                <div class="hSpace_10"></div>
                
                <div class="tab clearfix">
                    <h3>
                        <%= UIText.GetSafeText("VSite","Label_SystemChannels_Text",string.Empty ) %>
                    </h3>
                </div>
                <div class="tab-details">
                    <uc1:StoryCategoryList ID="StoryCategoryList1" CurrentCategoryType="HostChannel" runat="server" />
                </div>
            </div>
        </div>
        
        <div class="clear"></div>
    </div>
    
    
    <div id="footer">
        <asp:Footer ID="Footer1" runat="server" />
    </div>
    
    </div>
</div>