<%@ Control  Language="C#" EnableTheming="false" Inherits="EnjooSite.Web.UI.Controls.SystemWebPage.ClientTemplates.WidgetData"  %>
<%@ Import Namespace="EnjooSite.Extensibility.Interfaces" %>
<%@ Import Namespace="Newtonsoft.Json" %>
<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="EnjooSite.Framework.Text" %>
<%@ Import Namespace="System.Collections.Generic" %>

<script type="text/C#" runat="server">
    public string GetStaticHTML()
    {
        IPagedCollection<StaticHTML> pagedStaticHTMLs = StaticHTMLs.GetPaged(WidgetId, 1, ListCount);


        int maxItems = pagedStaticHTMLs.MaxItems;
        int lastPageCount = maxItems % ListCount;
        int pageCount = ((maxItems - lastPageCount) / ListCount);
        if (lastPageCount > 0)
        {
            pageCount++;
        }
        
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = new JsonTextWriter(stringWriter);
        jsonWriter.WriteStartObject();
        jsonWriter.WritePropertyName("widgetId");
        jsonWriter.WriteValue(WidgetId); 
        jsonWriter.WritePropertyName("maxItems");
        jsonWriter.WriteValue(pagedStaticHTMLs.MaxItems); 
        jsonWriter.WritePropertyName("pageCount");
        jsonWriter.WriteValue(pageCount); 
        jsonWriter.WritePropertyName("listCount");
        jsonWriter.WriteValue(ListCount); 
        jsonWriter.WritePropertyName("staticHTMLs");
        jsonWriter.WriteStartArray();
        foreach (StaticHTML item in pagedStaticHTMLs)
        {
            jsonWriter.WriteStartObject();
            jsonWriter.WritePropertyName("id");
            jsonWriter.WriteValue(item.Id);
            jsonWriter.WritePropertyName("title");
            jsonWriter.WriteValue(item.Title);
            jsonWriter.WritePropertyName("description");
            jsonWriter.WriteValue(item.Description);
            jsonWriter.WritePropertyName("dateadded");
            jsonWriter.WriteValue(UIText.NiceDateString( item.DateAdded));            
            jsonWriter.WriteEndObject();
        }

        jsonWriter.WriteEndArray();
        jsonWriter.WriteEndObject();
        jsonWriter.Flush();
        return stringWriter.GetStringBuilder().ToString();
    }
</script>
<%= GetStaticHTML() %>