<%@ Control Language="C#" EnableTheming="false"  Inherits="EnjooSite.Web.UI.Controls.Site.SiteMenu" %>
<%@ Import Namespace = "EnjooSite.Framework" %>
<%@ Import Namespace="EnjooSite.Web.UI" %>


<asp:ScriptManagerProxy ID="ScriptManagerProxy1" runat="server">
</asp:ScriptManagerProxy>

<asp:Repeater ID="SitesRepeater" Runat="server">
    <HeaderTemplate>
        <ul <%# IsEditMode %> commandname="enjoosite_webpage_list">
    </HeaderTemplate>
	<ItemTemplate>
	    <li <%# IsCurrentSite(Eval("ID").ToString()) %>>	    
	        <a href='<%# IsActivedSite(Eval("SiteName").ToString()) %>' siteID='<%# Eval("ID") %>'><span><%# Eval("Title") %></span></a>
	    </li>
	</ItemTemplate>
	<FooterTemplate>
	    <% if (IsEditing) 
        { %>
            <li class="normalLink webpage_add">
                <a id="layoutAddNewPage" href="#" title='<%= UIText.GetSafeText("SiteMenu","Layout_AddPage_Text" , string.Empty ) %>'><%= UIText.GetSafeText("SiteMenu","Layout_AddPage_Text" , string.Empty ) %></a>
            </li>
            <li class="normalLink webpage_delete">
                <a id="layoutDeleteCurrentPage" commandArgument='<%# CurrentSite.Id %>' href="#" title='<%= UIText.GetSafeText("SiteMenu","Layout_DeletePage_Text",string.Empty ) %>'><%= UIText.GetSafeText("SiteMenu","Layout_DeletePage_Text",string.Empty ) %></a>
            </li>
            <li class="normalLink webpage_logo_edit">
                <a id="layoutCurrentPageLogoEdit" commandArgument='<%# CurrentSite.Id %>' href="#" title='<%= UIText.GetSafeText("SiteMenu","Layout_LogoEdit_Text",string.Empty ) %>'><%= UIText.GetSafeText("SiteMenu","Layout_LogoEdit_Text",string.Empty ) %></a>
                <ul id="logoEditContainer" style="display:none;" class="v_list">
                    <li class="title">ҳĬLogo</li>
                    <li class="site_logo"></li>
                    <li class="title">ҳ׵ǰLogo</li>
                    <li id="webpageCustomLogoContainer" class="site_logo" <%= string.IsNullOrEmpty(Config.CurrentSite.LogoUrl)?"":string.Format("style=\"background-image:url({0});\"",Config.CurrentSite.LogoUrl) %>></li>
                    <li class="title" style="display:block;">
                    <ul class="h_list clearfix">
                        <li><a href="#" title="Logo" class="nice_button" commandname="updateSiteLogo"><span>ҳLogo</span></a></li>
                        <li><a href="#" title="ָҳĬLogo" class="nice_button" commandname="deleteSiteCustomLogo"><span>ָҳĬLogo</span></a></li>
                    </ul>
                    </li>
                    <li class="title">ҳβĬLogo</li>
                    <li class="site_footer_logo"></li>
                    <li class="title">ҳβǰLogo</li>
                    <li id="webpageCustomFooterLogoContainer" class="site_footer_logo" <%= string.IsNullOrEmpty(Config.CurrentSite.FooterLogoUrl)?"":string.Format("style=\"background-image:url({0});\"",Config.CurrentSite.FooterLogoUrl) %>></li>
                    <li class="title">
                    <ul class="h_list clearfix">
                        <li><a href="#" title="Logo" class="nice_button"  commandname="updateSiteFooterLogo"><span>ҳβLogo</span></a></li>
                        <li><a href="#" title="ָҳβĬLogo" class="nice_button"  commandname="deleteSiteCustomFooterLogo"><span>ָĬLogo</span></a></li>
                    </ul>
                    </li>
                    <li style="display:none;"><div id="logoEditorContainer" style="width:320px;" ></div></li>
                </ul>                
            </li>
	    <% } %>
        </ul>
	</FooterTemplate>
</asp:Repeater>