﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using COCOWO.COMP;
using COCOWO.DB;

public partial class Admin_guestbook : System.Web.UI.Page
{
    SqlDataBase SQLDB = new SqlDataBase();
    MyControl Ctrl = new MyControl();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!this.IsPostBack)
        {
            if (UsersInfo.GetUserCode.Substring(10, 1) != "1" && UsersInfo.GetmemhashKey != "")
            {
                Jscript.Alert("您不是管理员，不可以使用本功能!");
                BindLogout();
            }
            else if (UsersInfo.GetmemhashKey == null || UsersInfo.GetmemhashKey == "")
            {
                BindLogout();
            }
            BindGuestbook();
        }
    }

    /// <summary>
    /// 退出后台管理
    /// </summary>
    private void BindLogout()
    {
        Response.Cookies["memhashKey"].Value = "";
        Jscript.RefreshParent("Default.aspx");
    }
    /// <summary>
    /// 评论留言管理 - 评论管理
    /// </summary>
    private void BindGuestbook()
    {
        Comment.Visible = true;
        DataView mydv = blog_book_list("", "book_ID desc", Application["blogcommpage"].ToString(), QueryString.IntPage.ToString());
        MultiPage1.CountSum = Convert.ToInt32(Book_Count(Application["blogcommpage"].ToString()));
        MultiPage1.CountSum = Convert.ToInt32(Book_Count(Application["blogcommpage"].ToString()));
        Ctrl.BindDataList(Commend_List, mydv);
    }
    /// <summary>
    /// 返回留言信息
    /// </summary>
    /// <param name="SearchCondition">查询条件</param>
    /// <param name="OrderList">排序列表</param>
    /// <param name="PageSize">每页的大小</param>
    /// <param name="PageIndex">要显示的页码</param>
    /// <returns></returns>
    public DataView blog_book_list(string SearchCondition, string OrderList, string PageSize, string PageIndex)
    {
        string @SQL;
        string @SQL2;
        string @strSQL;
        int @MinID;
        @MinID = (Convert.ToInt32(@PageIndex) - 1) * Convert.ToInt32(@PageSize); //获取上一页的最大ID

        @strSQL = "*";
        //------
        if (@SearchCondition != "")
        {
            @SQL = "WHERE " + @SearchCondition;
            @SQL2 = "AND " + @SearchCondition;
        }
        else
        {
            @SQL = "";
            @SQL2 = "";
        }
        //------
        if (@OrderList != "")
        {
            @SQL = @SQL + " ORDER BY " + @OrderList + " ";
            @SQL2 = @SQL2 + " ORDER BY " + @OrderList + " ";
        }
        //------
        if (@PageSize == "")
            @PageSize = "10";

        if (Convert.ToInt32(@PageIndex) > 1)
            return SQLDB.GetDv("SELECT TOP " + @PageSize + " " + @strSQL + " FROM blog_book	 WHERE (book_ID < (SELECT Min(book_ID) FROM (SELECT TOP " + @MinID + " book_ID FROM blog_book  " + @SQL + ") AS T)) " + @SQL2 + "");
        else
            return SQLDB.GetDv("SELECT TOP " + @PageSize + " " + @strSQL + " FROM blog_book " + @SQL + "");
    }
    /// <summary>
    /// 获取留言总分页数--后台
    /// </summary>
    /// <returns></returns>
    public string Book_Count(string blogcommpage)
    {
        return SQLDB.RunSqlReturn("SELECT int(count(book_ID)/" + blogcommpage + ".0) FROM blog_book");
    }
    /// <summary>
    /// 留言修改
    /// </summary>
    /// <param name="comm_ID">主题ID</param>
    /// <param name="commContent">内容</param>
    /// <returns></returns>
    public void Book_UPDATE(string book_ID, string book_Content)
    {
        SQLDB.RunSql("UPDATE blog_book SET book_Content='" + book_Content + "' where book_ID=" + book_ID + "");
    }
    /// <summary>
    /// 留言删除
    /// </summary>
    /// <param name="comm_ID">主题ID</param>
    /// <returns></returns>
    public void Book_DELETE(string book_ID)
    {
        SQLDB.RunSql("DELETE FROM blog_book where book_ID=" + book_ID + "");
        //---------这一部分是修改前台显示10条部分的------------
        DataView mydv = SQLDB.GetDv("SELECT TOP 10 * FROM blog_book where book_HiddenReply<>0 order by book_replyTime desc");
        string NewComment = "";
        for (int i = 0; i < mydv.Count; i++)
        {
            NewComment += @"<a class=""sideA"" href=""guestbook.aspx"" title=""" + mydv[i]["book_Messager"].ToString() + @" 于 " + mydv[i]["book_replyTime"].ToString() + @" 发表评论&#13;" + StringUtil.GetSubString(mydv[i]["book_content"].ToString(), 100) + @""">" + StringUtil.GetSubString(mydv[i]["book_content"].ToString(), 25) + @"</a>";
        }
        NewComment = StringUtil.CheckStr(@"<div class=""commentTable"">" + NewComment + @"</div>");
        SQLDB.RunSql("UPDATE blog_module SET HtmlCode='" + NewComment + "' WHERE name='GuestBookForCOCOWO_Blog'");
        //---------这一部分是修改前台显示10条部分的---END---------
    }
    protected void Button8_Click(object sender, EventArgs e)
    {
        for (int i = 0; i < Commend_List.Items.Count; i++)
        {
            TextBox message = ((TextBox)Commend_List.Items[i].FindControl("message"));
            string book_ID = Commend_List.DataKeys[i].ToString();
            Book_UPDATE(book_ID, message.Text);
        }
    }
    protected void Button9_Click(object sender, EventArgs e)
    {
        for (int i = 0; i < Commend_List.Items.Count; i++)
        {
            CheckBox selectCommentID = ((CheckBox)Commend_List.Items[i].FindControl("selectCommentID"));
            if (selectCommentID.Checked)
                Book_DELETE(Commend_List.DataKeys[i].ToString());
        }
        BindGuestbook();
    }
}
