/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.builder.xml;

import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.builder.IncompleteElementException;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.parsing.PropertyParser;
import org.apache.ibatis.parsing.XNode;
import org.apache.ibatis.session.Configuration;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLIncludeTransformer {
    private final Configuration configuration;
    private final MapperBuilderAssistant builderAssistant;

    public XMLIncludeTransformer(Configuration configuration, MapperBuilderAssistant builderAssistant) {
        this.configuration = configuration;
        this.builderAssistant = builderAssistant;
    }

    public void applyIncludes(Node source) {
        Properties variablesContext = new Properties();
        Properties configurationVariables = this.configuration.getVariables();
        if (configurationVariables != null) {
            variablesContext.putAll((Map<?, ?>)configurationVariables);
        }
        this.applyIncludes(source, variablesContext);
    }

    private void applyIncludes(Node source, Properties variablesContext) {
        if (source.getNodeName().equals("include")) {
            Properties fullContext;
            String refid = this.getStringAttribute(source, "refid");
            refid = PropertyParser.parse(refid, variablesContext);
            Node toInclude = this.findSqlFragment(refid);
            Properties newVariablesContext = this.getVariablesContext(source, variablesContext);
            if (!newVariablesContext.isEmpty()) {
                fullContext = new Properties();
                fullContext.putAll((Map<?, ?>)variablesContext);
                fullContext.putAll((Map<?, ?>)newVariablesContext);
            } else {
                fullContext = variablesContext;
            }
            this.applyIncludes(toInclude, fullContext);
            if (toInclude.getOwnerDocument() != source.getOwnerDocument()) {
                toInclude = source.getOwnerDocument().importNode(toInclude, true);
            }
            source.getParentNode().replaceChild(toInclude, source);
            while (toInclude.hasChildNodes()) {
                toInclude.getParentNode().insertBefore(toInclude.getFirstChild(), toInclude);
            }
            toInclude.getParentNode().removeChild(toInclude);
        } else if (source.getNodeType() == 1) {
            NodeList children = source.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                this.applyIncludes(children.item(i), variablesContext);
            }
        } else if (source.getNodeType() == 2 && !variablesContext.isEmpty()) {
            source.setNodeValue(PropertyParser.parse(source.getNodeValue(), variablesContext));
        } else if (source.getNodeType() == 3 && !variablesContext.isEmpty()) {
            source.setNodeValue(PropertyParser.parse(source.getNodeValue(), variablesContext));
        }
    }

    private Node findSqlFragment(String refid) {
        refid = this.builderAssistant.applyCurrentNamespace(refid, true);
        try {
            XNode nodeToInclude = this.configuration.getSqlFragments().get(refid);
            return nodeToInclude.getNode().cloneNode(true);
        }
        catch (IllegalArgumentException e) {
            throw new IncompleteElementException("Could not find SQL statement to include with refid '" + refid + "'", e);
        }
    }

    private String getStringAttribute(Node node, String name) {
        return node.getAttributes().getNamedItem(name).getNodeValue();
    }

    private Properties getVariablesContext(Node node, Properties inheritedVariablesContext) {
        Properties variablesContext = new Properties();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (n.getNodeType() != 1) continue;
            String name = this.getStringAttribute(n, "name");
            String value = this.getStringAttribute(n, "value");
            Object originalValue = variablesContext.put(name, value = PropertyParser.parse(value, inheritedVariablesContext));
            if (originalValue == null) continue;
            throw new BuilderException("Variable " + name + " defined twice in the same include definition");
        }
        return variablesContext;
    }
}

