/*
 * Decompiled with CFR 0.152.
 */
package com.lxinet.jeesns.service.cms.impl;

import com.lxinet.jeesns.common.utils.ActionUtil;
import com.lxinet.jeesns.common.utils.ScoreRuleConsts;
import com.lxinet.jeesns.core.dto.ResponseModel;
import com.lxinet.jeesns.core.model.Page;
import com.lxinet.jeesns.core.utils.StringUtils;
import com.lxinet.jeesns.dao.cms.IArticleCommentDao;
import com.lxinet.jeesns.model.cms.Article;
import com.lxinet.jeesns.model.cms.ArticleComment;
import com.lxinet.jeesns.model.member.Member;
import com.lxinet.jeesns.service.cms.IArticleCommentService;
import com.lxinet.jeesns.service.cms.IArticleService;
import com.lxinet.jeesns.service.member.IScoreDetailService;
import com.lxinet.jeesns.service.system.IActionLogService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="articleCommentService")
public class ArticleCommentServiceImpl
implements IArticleCommentService {
    @Resource
    private IArticleCommentDao articleCommentDao;
    @Resource
    private IArticleService articleService;
    @Resource
    private IActionLogService actionLogService;
    @Resource
    private IScoreDetailService scoreDetailService;

    @Override
    public ArticleComment findById(int id) {
        return (ArticleComment)this.articleCommentDao.findById(Integer.valueOf(id));
    }

    @Override
    public ResponseModel save(Member loginMember, String content, Integer articleId) {
        Article article = this.articleService.findById(articleId);
        if (article == null) {
            return new ResponseModel(-1, "\u6587\u7ae0\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isEmpty((String)content)) {
            return new ResponseModel(-1, "\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArticleComment articleComment = new ArticleComment();
        articleComment.setMemberId(loginMember.getId());
        articleComment.setArticleId(articleId);
        articleComment.setContent(content);
        int result = this.articleCommentDao.save((Object)articleComment);
        if (result == 1) {
            this.scoreDetailService.scoreBonus(loginMember.getId(), ScoreRuleConsts.ARTICLE_REVIEWS, articleComment.getId());
            return new ResponseModel(1, "\u8bc4\u8bba\u6210\u529f");
        }
        return new ResponseModel(-1, "\u8bc4\u8bba\u5931\u8d25");
    }

    @Override
    public ResponseModel listByArticle(Page page, int articleId) {
        List list = this.articleCommentDao.listByArticle(page, Integer.valueOf(articleId));
        ResponseModel model = new ResponseModel(0, page);
        model.setData((Object)list);
        return model;
    }

    @Override
    public void deleteByArticle(Integer articleId) {
        this.articleCommentDao.deleteByArticle(articleId);
    }

    @Override
    @Transactional
    public ResponseModel delete(Member loginMember, int id) {
        ArticleComment articleComment = this.findById(id);
        if (articleComment == null) {
            return new ResponseModel(-1, "\u8bc4\u8bba\u4e0d\u5b58\u5728");
        }
        int result = this.articleCommentDao.delete(Integer.valueOf(id));
        if (result == 1) {
            this.scoreDetailService.scoreCancelBonus(loginMember.getId(), ScoreRuleConsts.ARTICLE_REVIEWS, id);
            this.actionLogService.save(loginMember.getCurrLoginIp(), loginMember.getId(), ActionUtil.DELETE_ARTICLE_COMMENT, "ID\uff1a" + articleComment.getId() + "\uff0c\u5185\u5bb9\uff1a" + articleComment.getContent());
            return new ResponseModel(1, "\u5220\u9664\u6210\u529f");
        }
        return new ResponseModel(-1, "\u5220\u9664\u5931\u8d25");
    }
}

