/*
 * Decompiled with CFR 0.152.
 */
package com.lxinet.jeesns.service.cms.impl;

import com.lxinet.jeesns.common.utils.ActionLogType;
import com.lxinet.jeesns.common.utils.ActionUtil;
import com.lxinet.jeesns.common.utils.ScoreRuleConsts;
import com.lxinet.jeesns.core.dto.ResponseModel;
import com.lxinet.jeesns.core.model.Page;
import com.lxinet.jeesns.core.utils.StringUtils;
import com.lxinet.jeesns.dao.cms.IArticleDao;
import com.lxinet.jeesns.model.cms.Article;
import com.lxinet.jeesns.model.common.Archive;
import com.lxinet.jeesns.model.member.Member;
import com.lxinet.jeesns.service.cms.IArticleCommentService;
import com.lxinet.jeesns.service.cms.IArticleService;
import com.lxinet.jeesns.service.common.IArchiveService;
import com.lxinet.jeesns.service.member.IScoreDetailService;
import com.lxinet.jeesns.service.system.IActionLogService;
import com.lxinet.jeesns.service.system.IConfigService;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="articleService")
public class ArticleServiceImpl
implements IArticleService {
    @Resource
    private IArticleDao articleDao;
    @Resource
    private IArchiveService archiveService;
    @Resource
    private IConfigService configService;
    @Resource
    private IArticleCommentService articleCommentService;
    @Resource
    private IActionLogService actionLogService;
    @Resource
    private IScoreDetailService scoreDetailService;

    @Override
    public Article findById(int id) {
        return this.articleDao.findById(Integer.valueOf(id), Integer.valueOf(0));
    }

    @Override
    public Article findById(int id, Member loginMember) {
        int loginMemberId = loginMember == null ? 0 : loginMember.getId();
        return this.articleDao.findById(Integer.valueOf(id), Integer.valueOf(loginMemberId));
    }

    @Override
    @Transactional
    public ResponseModel save(Member member, Article article) {
        Map<String, String> config = this.configService.getConfigToMap();
        if (member.getIsAdmin() == 0 && "0".equals(config.get("cms_post"))) {
            return new ResponseModel(-1, "\u6295\u7a3f\u529f\u80fd\u5df2\u5173\u95ed");
        }
        if (article.getCateId() == null || article.getCateId() == 0) {
            return new ResponseModel(-1, "\u680f\u76ee\u4e0d\u80fd\u4e3a\u7a7a");
        }
        article.setMemberId(member.getId());
        Archive archive = new Archive();
        try {
            archive = archive.copy((Object)article);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        archive.setPostType(Integer.valueOf(1));
        if (member.getIsAdmin() == 0 && "0".equals(config.get("cms_post_review"))) {
            article.setStatus(Integer.valueOf(0));
        } else {
            article.setStatus(Integer.valueOf(1));
        }
        if (this.archiveService.save(member, archive)) {
            article.setArchiveId(archive.getArchiveId());
            int result = this.articleDao.save(article);
            if (result == 1) {
                if (article.getStatus() == 1) {
                    this.scoreDetailService.scoreBonus(article.getMemberId(), ScoreRuleConsts.ARTICLE_SUBMISSIONS, article.getId());
                }
                this.actionLogService.save(member.getCurrLoginIp(), member.getId(), ActionUtil.POST_ARTICLE, "", ActionLogType.ARTICLE.getValue(), article.getId());
                if (article.getStatus() == 0) {
                    return new ResponseModel(0, "\u6587\u7ae0\u53d1\u5e03\u6210\u529f\uff0c\u8bf7\u7b49\u5f85\u5ba1\u6838");
                }
                return new ResponseModel(0, "\u6587\u7ae0\u53d1\u5e03\u6210\u529f");
            }
        }
        return new ResponseModel(-1, "\u6587\u7ae0\u53d1\u5e03\u5931\u8d25");
    }

    @Override
    public ResponseModel listByPage(Page page, String key, int cateid, int status, int memberId) {
        if (StringUtils.isNotBlank((String)key)) {
            key = "%" + key + "%";
        }
        List list = this.articleDao.listByPage(page, key, Integer.valueOf(cateid), Integer.valueOf(status), Integer.valueOf(memberId));
        ResponseModel model = new ResponseModel(0, page);
        model.setData((Object)list);
        return model;
    }

    @Override
    public void updateViewCount(int id) {
        this.articleDao.updateViewCount(id);
    }

    @Override
    public ResponseModel audit(int id) {
        if (this.articleDao.audit(id) == 1) {
            Article article = this.findById(id);
            if (article != null && article.getStatus() == 1) {
                this.scoreDetailService.scoreBonus(article.getMemberId(), ScoreRuleConsts.ARTICLE_SUBMISSIONS, article.getId());
            }
            return new ResponseModel(1, "\u64cd\u4f5c\u6210\u529f");
        }
        return new ResponseModel(-1, "\u64cd\u4f5c\u65f6\u5019");
    }

    @Override
    public ResponseModel favor(Member loginMember, int articleId) {
        Article article = this.findById(articleId);
        if (article != null) {
            ResponseModel responseModel = this.archiveService.favor(loginMember, article.getArchiveId());
            if (responseModel.getCode() == 0) {
                this.scoreDetailService.scoreBonus(loginMember.getId(), ScoreRuleConsts.ARTICLE_RECEIVED_LIKE, articleId);
            } else if (responseModel.getCode() == 1) {
                this.scoreDetailService.scoreCancelBonus(loginMember.getId(), ScoreRuleConsts.ARTICLE_RECEIVED_LIKE, articleId);
            }
            return responseModel;
        }
        return new ResponseModel(-1, "\u6587\u7ae0\u4e0d\u5b58\u5728");
    }

    @Override
    public List<Article> listByCustom(int cid, String sort, int num, int day, int thumbnail) {
        return this.articleDao.listByCustom(cid, sort, num, day, thumbnail);
    }

    @Override
    @Transactional
    public ResponseModel update(Member member, Article article) {
        Article findArticle = this.findById(article.getId(), member);
        if (findArticle == null) {
            return new ResponseModel(-2);
        }
        article.setArchiveId(findArticle.getArchiveId());
        Archive archive = new Archive();
        try {
            archive = archive.copy((Object)article);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.archiveService.update(member, archive)) {
            Map<String, String> config = this.configService.getConfigToMap();
            if (member.getIsAdmin() == 0 && "0".equals(config.get("cms_post_review"))) {
                findArticle.setStatus(Integer.valueOf(0));
            } else {
                findArticle.setStatus(Integer.valueOf(1));
            }
            findArticle.setCateId(article.getCateId());
            this.articleDao.update((Object)findArticle);
            return new ResponseModel(0, "\u66f4\u65b0\u6210\u529f");
        }
        return new ResponseModel(-1, "\u66f4\u65b0\u5931\u8d25");
    }

    @Override
    @Transactional
    public ResponseModel delete(Member member, int id) {
        Article article = this.findById(id);
        if (article == null) {
            return new ResponseModel(-1, "\u6587\u7ae0\u4e0d\u5b58\u5728");
        }
        int result = this.articleDao.delete(Integer.valueOf(id));
        if (result == 1) {
            this.scoreDetailService.scoreCancelBonus(member.getId(), ScoreRuleConsts.ARTICLE_SUBMISSIONS, id);
            this.archiveService.delete(article.getArchiveId());
            this.articleCommentService.deleteByArticle(id);
            this.actionLogService.save(member.getCurrLoginIp(), member.getId(), ActionUtil.DELETE_ARTICLE, "ID\uff1a" + article.getId() + "\uff0c\u6807\u9898\uff1a" + article.getTitle());
            return new ResponseModel(1, "\u5220\u9664\u6210\u529f");
        }
        return new ResponseModel(-1, "\u5220\u9664\u5931\u8d25");
    }
}

