/*
 * Decompiled with CFR 0.152.
 */
package com.lxinet.jeesns.service.group.impl;

import com.lxinet.jeesns.common.utils.ActionUtil;
import com.lxinet.jeesns.common.utils.ScoreRuleConsts;
import com.lxinet.jeesns.core.dto.ResponseModel;
import com.lxinet.jeesns.core.model.Page;
import com.lxinet.jeesns.core.utils.StringUtils;
import com.lxinet.jeesns.dao.group.IGroupDao;
import com.lxinet.jeesns.model.group.Group;
import com.lxinet.jeesns.model.member.Member;
import com.lxinet.jeesns.service.group.IGroupFansService;
import com.lxinet.jeesns.service.group.IGroupService;
import com.lxinet.jeesns.service.member.IMemberService;
import com.lxinet.jeesns.service.member.IScoreDetailService;
import com.lxinet.jeesns.service.system.IActionLogService;
import com.lxinet.jeesns.service.system.IConfigService;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="groupService")
public class GroupServiceImpl
implements IGroupService {
    @Resource
    private IGroupDao groupDao;
    @Resource
    private IGroupFansService groupFansService;
    @Resource
    private IMemberService memberService;
    @Resource
    private IConfigService configService;
    @Resource
    private IActionLogService actionLogService;
    @Resource
    private IScoreDetailService scoreDetailService;

    @Override
    public ResponseModel listByPage(int status, Page page, String key) {
        if (StringUtils.isNotBlank((String)key)) {
            key = "%" + key.trim() + "%";
        }
        List list = this.groupDao.listByPage(page, Integer.valueOf(status), key);
        ResponseModel model = new ResponseModel(0, page);
        model.setData((Object)list);
        return model;
    }

    @Override
    public ResponseModel follow(Member loginMember, Integer groupId, int type) {
        Group group = this.findById(groupId);
        if (group == null) {
            return new ResponseModel(-1, "\u7fa4\u7ec4\u4e0d\u5b58\u5728");
        }
        if (type == 0) {
            return this.groupFansService.save(loginMember, groupId);
        }
        if (loginMember.getId().intValue() == group.getCreator().intValue()) {
            return new ResponseModel(-1, "\u7ba1\u7406\u5458\u4e0d\u80fd\u53d6\u6d88\u5173\u6ce8");
        }
        return this.groupFansService.delete(loginMember, groupId);
    }

    @Override
    public ResponseModel changeStatus(int id) {
        if (this.groupDao.changeStatus(Integer.valueOf(id)) == 1) {
            return new ResponseModel(1, "\u64cd\u4f5c\u6210\u529f");
        }
        return new ResponseModel(-1, "\u64cd\u4f5c\u5931\u8d25");
    }

    @Override
    public List<Group> listByCustom(int status, int num, String sort) {
        return this.groupDao.listByCustom(status, num, sort);
    }

    @Override
    public Group findById(int id) {
        return (Group)this.groupDao.findById(Integer.valueOf(id));
    }

    @Override
    @Transactional
    public ResponseModel save(Member loginMember, Group group) {
        Map<String, String> config = this.configService.getConfigToMap();
        group.setCreator(loginMember.getId());
        if (loginMember.getIsAdmin() > 0) {
            group.setStatus(Integer.valueOf(1));
        } else {
            if ("0".equals(config.get("group_apply"))) {
                return new ResponseModel(-1, "\u7fa4\u7ec4\u7533\u8bf7\u529f\u80fd\u5df2\u5173\u95ed");
            }
            if ("0".equals(config.get("group_apply_review"))) {
                group.setStatus(Integer.valueOf(0));
            } else {
                group.setStatus(Integer.valueOf(1));
            }
        }
        if (StringUtils.isEmpty((String)group.getLogo())) {
            group.setLogo("/res/common/images/nopic.png");
        }
        String managerIds = String.valueOf(loginMember.getId());
        group.setManagers(managerIds);
        group.setCanPost(Integer.valueOf(1));
        group.setTopicReview(Integer.valueOf(0));
        if (this.groupDao.save((Object)group) == 1) {
            this.groupFansService.save(loginMember, group.getId());
            this.scoreDetailService.scoreBonus(loginMember.getId(), ScoreRuleConsts.APPLY_GROUP, group.getId());
            return new ResponseModel(1, "\u7533\u8bf7\u6210\u529f\uff0c\u8bf7\u7b49\u5f85\u5ba1\u6838");
        }
        return new ResponseModel(-1, "\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
    }

    @Override
    public ResponseModel update(Member loginMember, Group group) {
        Group findGroup = this.findById(group.getId());
        if (findGroup == null) {
            return new ResponseModel(-1, "\u7fa4\u7ec4\u4e0d\u5b58\u5728");
        }
        if (loginMember.getId().intValue() != findGroup.getCreator().intValue()) {
            return new ResponseModel(-1, "\u6ca1\u6709\u6743\u9650");
        }
        String managerNames = group.getManagers();
        String managerIds = "";
        String[] names = managerNames.split(",");
        if (names.length > 10) {
            return new ResponseModel(-1, "\u7ba1\u7406\u5458\u4e0d\u80fd\u8d85\u8fc710\u4e2a");
        }
        for (String name : names) {
            Member member = this.memberService.findByName(name.trim());
            if (member == null) continue;
            managerIds = managerIds + member.getId() + ",";
        }
        if (managerIds.length() > 0) {
            managerIds = managerIds.substring(0, managerIds.length() - 1);
        }
        if (StringUtils.isNotEmpty((String)group.getLogo())) {
            findGroup.setLogo(group.getLogo());
        }
        findGroup.setManagers(managerIds);
        findGroup.setName(group.getName());
        findGroup.setTags(group.getTags());
        findGroup.setCanPost(group.getCanPost());
        findGroup.setTopicReview(group.getTopicReview());
        findGroup.setIntroduce(group.getIntroduce());
        if (this.groupDao.update((Object)findGroup) == 1) {
            return new ResponseModel(1, "\u64cd\u4f5c\u6210\u529f");
        }
        return new ResponseModel(-1, "\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
    }

    @Override
    public ResponseModel delete(Member loginMember, int id) {
        Group group = this.findById(id);
        if (group == null) {
            return new ResponseModel(-1, "\u7fa4\u7ec4\u4e0d\u5b58\u5728");
        }
        if (this.groupDao.delete(Integer.valueOf(id)) == 1) {
            this.actionLogService.save(loginMember.getCurrLoginIp(), loginMember.getId(), ActionUtil.DELETE_GROUP, "ID\uff1a" + group.getId() + "\uff0c\u540d\u5b57\uff1a" + group.getName());
            return new ResponseModel(1, "\u5220\u9664\u6210\u529f");
        }
        return new ResponseModel(-1, "\u5220\u9664\u5931\u8d25");
    }
}

