/*
 * Decompiled with CFR 0.152.
 */
package com.lxinet.jeesns.service.group.impl;

import com.lxinet.jeesns.common.utils.ActionUtil;
import com.lxinet.jeesns.common.utils.ScoreRuleConsts;
import com.lxinet.jeesns.core.dto.ResponseModel;
import com.lxinet.jeesns.core.model.Page;
import com.lxinet.jeesns.core.utils.StringUtils;
import com.lxinet.jeesns.dao.group.IGroupTopicCommentDao;
import com.lxinet.jeesns.model.group.GroupTopic;
import com.lxinet.jeesns.model.group.GroupTopicComment;
import com.lxinet.jeesns.model.member.Member;
import com.lxinet.jeesns.service.group.IGroupTopicCommentService;
import com.lxinet.jeesns.service.group.IGroupTopicService;
import com.lxinet.jeesns.service.member.IScoreDetailService;
import com.lxinet.jeesns.service.system.IActionLogService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="groupTopicCommentService")
public class GroupTopicCommentServiceImpl
implements IGroupTopicCommentService {
    @Resource
    private IGroupTopicCommentDao groupTopicCommentDao;
    @Resource
    private IGroupTopicService groupTopicService;
    @Resource
    private IActionLogService actionLogService;
    @Resource
    private IScoreDetailService scoreDetailService;

    @Override
    public GroupTopicComment findById(int id) {
        return (GroupTopicComment)this.groupTopicCommentDao.findById(Integer.valueOf(id));
    }

    @Override
    public ResponseModel save(Member loginMember, String content, Integer groupTopicId, Integer commentId) {
        GroupTopic groupTopic = this.groupTopicService.findById(groupTopicId, loginMember);
        if (groupTopic == null) {
            return new ResponseModel(-1, "\u5e16\u5b50\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isEmpty((String)content)) {
            return new ResponseModel(-1, "\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        GroupTopicComment groupTopicComment = new GroupTopicComment();
        groupTopicComment.setMemberId(loginMember.getId());
        groupTopicComment.setGroupTopicId(groupTopicId);
        groupTopicComment.setContent(content);
        groupTopicComment.setCommentId(commentId);
        int result = this.groupTopicCommentDao.save((Object)groupTopicComment);
        if (result == 1) {
            this.scoreDetailService.scoreBonus(loginMember.getId(), ScoreRuleConsts.GROUP_TOPIC_COMMENTS, groupTopicComment.getId());
            return new ResponseModel(1, "\u8bc4\u8bba\u6210\u529f");
        }
        return new ResponseModel(-1, "\u8bc4\u8bba\u5931\u8d25");
    }

    @Override
    public ResponseModel listByGroupTopic(Page page, int groupTopicId) {
        List list = this.groupTopicCommentDao.listByGroupTopic(page, Integer.valueOf(groupTopicId));
        ResponseModel model = new ResponseModel(0, page);
        model.setData((Object)list);
        return model;
    }

    @Override
    public void deleteByTopic(int groupTopicId) {
        this.groupTopicCommentDao.deleteByTopic(Integer.valueOf(groupTopicId));
    }

    @Override
    public ResponseModel delete(Member loginMember, int id) {
        GroupTopicComment groupTopicComment = this.findById(id);
        if (groupTopicComment == null) {
            return new ResponseModel(-1, "\u8bc4\u8bba\u4e0d\u5b58\u5728");
        }
        int result = this.groupTopicCommentDao.delete(Integer.valueOf(id));
        if (result == 1) {
            this.scoreDetailService.scoreCancelBonus(loginMember.getId(), ScoreRuleConsts.GROUP_TOPIC_COMMENTS, id);
            this.actionLogService.save(loginMember.getCurrLoginIp(), loginMember.getId(), ActionUtil.DELETE_GROUP_TOPIC_COMMENT, "ID\uff1a" + groupTopicComment.getId() + "\uff0c\u5185\u5bb9\uff1a" + groupTopicComment.getContent());
            return new ResponseModel(1, "\u5220\u9664\u6210\u529f");
        }
        return new ResponseModel(-1, "\u5220\u9664\u5931\u8d25");
    }
}

