/*
 * Decompiled with CFR 0.152.
 */
package com.lxinet.jeesns.service.group.impl;

import com.lxinet.jeesns.common.utils.ActionLogType;
import com.lxinet.jeesns.common.utils.ActionUtil;
import com.lxinet.jeesns.common.utils.ScoreRuleConsts;
import com.lxinet.jeesns.core.dto.ResponseModel;
import com.lxinet.jeesns.core.model.Page;
import com.lxinet.jeesns.core.utils.StringUtils;
import com.lxinet.jeesns.dao.group.IGroupTopicDao;
import com.lxinet.jeesns.model.common.Archive;
import com.lxinet.jeesns.model.group.Group;
import com.lxinet.jeesns.model.group.GroupTopic;
import com.lxinet.jeesns.model.member.Member;
import com.lxinet.jeesns.service.common.IArchiveService;
import com.lxinet.jeesns.service.group.IGroupFansService;
import com.lxinet.jeesns.service.group.IGroupService;
import com.lxinet.jeesns.service.group.IGroupTopicCommentService;
import com.lxinet.jeesns.service.group.IGroupTopicService;
import com.lxinet.jeesns.service.member.IScoreDetailService;
import com.lxinet.jeesns.service.system.IActionLogService;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="groupTopicService")
public class GroupTopicServiceImpl
implements IGroupTopicService {
    @Resource
    private IGroupTopicDao groupTopicDao;
    @Resource
    private IGroupService groupService;
    @Resource
    private IGroupTopicCommentService groupTopicCommentService;
    @Resource
    private IGroupFansService groupFansService;
    @Resource
    private IArchiveService archiveService;
    @Resource
    private IActionLogService actionLogService;
    @Resource
    private IScoreDetailService scoreDetailService;

    @Override
    public GroupTopic findById(int id) {
        return this.groupTopicDao.findById(Integer.valueOf(id), Integer.valueOf(0));
    }

    @Override
    public GroupTopic findById(int id, Member loginMember) {
        int loginMemberId = loginMember == null ? 0 : loginMember.getId();
        return this.groupTopicDao.findById(Integer.valueOf(id), Integer.valueOf(loginMemberId));
    }

    @Override
    @Transactional
    public ResponseModel save(Member member, GroupTopic groupTopic) {
        if (groupTopic.getGroupId() == null || groupTopic.getGroupId() == 0) {
            return new ResponseModel(-1, "\u7fa4\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Group group = this.groupService.findById(groupTopic.getGroupId());
        if (group == null) {
            return new ResponseModel(-1, "\u7fa4\u7ec4\u4e0d\u5b58\u5728");
        }
        if (this.groupFansService.findByMemberAndGroup(group.getId(), member.getId()) == null) {
            return new ResponseModel(-1, "\u5fc5\u987b\u5173\u6ce8\u8be5\u7fa4\u7ec4\u540e\u624d\u80fd\u53d1\u5e16");
        }
        if (group.getCanPost() == 0) {
            return new ResponseModel(-1, "\u7fa4\u7ec4\u5df2\u5173\u95ed\u53d1\u5e16\u529f\u80fd");
        }
        groupTopic.setMemberId(member.getId());
        Archive archive = new Archive();
        try {
            archive = archive.copy((Object)groupTopic);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        archive.setPostType(Integer.valueOf(2));
        if (this.archiveService.save(member, archive)) {
            groupTopic.setStatus(Integer.valueOf(group.getTopicReview() == 0 ? 1 : 0));
            groupTopic.setArchiveId(archive.getArchiveId());
            int result = this.groupTopicDao.save(groupTopic);
            if (result == 1) {
                this.scoreDetailService.scoreBonus(member.getId(), ScoreRuleConsts.GROUP_POST, groupTopic.getId());
                this.actionLogService.save(member.getCurrLoginIp(), member.getId(), ActionUtil.POST_GROUP_TOPIC, "", ActionLogType.GROUP_TOPIC.getValue(), groupTopic.getId());
                if (groupTopic.getStatus() == 0) {
                    return new ResponseModel(2, "\u5e16\u5b50\u53d1\u5e03\u6210\u529f\uff0c\u8bf7\u7b49\u5f85\u7ba1\u7406\u5458\u5ba1\u6838\u901a\u8fc7", "../detail/" + groupTopic.getGroupId());
                }
                return new ResponseModel(2, "\u5e16\u5b50\u53d1\u5e03\u6210\u529f", "../topic/" + groupTopic.getId());
            }
        }
        return new ResponseModel(-1, "\u5e16\u5b50\u53d1\u5e03\u5931\u8d25");
    }

    @Override
    public ResponseModel listByPage(Page page, String key, int groupId, int status, int memberId) {
        if (StringUtils.isNotBlank((String)key)) {
            key = "%" + key + "%";
        }
        List list = this.groupTopicDao.listByPage(page, key, Integer.valueOf(groupId), Integer.valueOf(status), Integer.valueOf(memberId));
        ResponseModel model = new ResponseModel(0, page);
        model.setData((Object)list);
        return model;
    }

    @Override
    @Transactional
    public ResponseModel update(Member member, GroupTopic groupTopic) {
        GroupTopic findGroupTopic = this.findById(groupTopic.getId(), member);
        if (findGroupTopic == null) {
            return new ResponseModel(-2);
        }
        if (member.getId().intValue() != findGroupTopic.getMember().getId().intValue()) {
            return new ResponseModel(-1, "\u6ca1\u6709\u6743\u9650");
        }
        groupTopic.setArchiveId(findGroupTopic.getArchiveId());
        Archive archive = new Archive();
        try {
            archive = archive.copy((Object)groupTopic);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.archiveService.update(member, archive)) {
            return new ResponseModel(0, "\u66f4\u65b0\u6210\u529f");
        }
        return new ResponseModel(-1, "\u66f4\u65b0\u5931\u8d25");
    }

    @Override
    @Transactional
    public ResponseModel delete(Member loginMember, int id) {
        GroupTopic groupTopic = this.findById(id);
        if (groupTopic == null) {
            return new ResponseModel(-1, "\u5e16\u5b50\u4e0d\u5b58\u5728");
        }
        int result = this.groupTopicDao.delete(Integer.valueOf(id));
        if (result == 1) {
            this.scoreDetailService.scoreCancelBonus(loginMember.getId(), ScoreRuleConsts.GROUP_POST, id);
            this.archiveService.delete(groupTopic.getArchiveId());
            this.groupTopicCommentService.deleteByTopic(id);
            this.actionLogService.save(loginMember.getCurrLoginIp(), loginMember.getId(), ActionUtil.DELETE_GROUP_TOPIC, "ID\uff1a" + groupTopic.getId() + "\uff0c\u6807\u9898\uff1a" + groupTopic.getTitle());
            return new ResponseModel(1, "\u5220\u9664\u6210\u529f");
        }
        return new ResponseModel(-1, "\u5220\u9664\u5931\u8d25");
    }

    @Override
    @Transactional
    public ResponseModel indexDelete(HttpServletRequest request, Member loginMember, int id) {
        if (loginMember == null) {
            return new ResponseModel(-1, "\u8bf7\u5148\u767b\u5f55");
        }
        GroupTopic groupTopic = this.findById(id, loginMember);
        if (groupTopic == null) {
            return new ResponseModel(-1, "\u5e16\u5b50\u4e0d\u5b58\u5728");
        }
        Group group = this.groupService.findById(groupTopic.getGroup().getId());
        if (group == null) {
            return new ResponseModel(-1, "\u51fa\u73b0\u5f02\u5e38");
        }
        String groupManagers = group.getManagers();
        String[] groupManagerArr = groupManagers.split(",");
        boolean isManager = false;
        for (String manager : groupManagerArr) {
            if (loginMember.getId() != Integer.parseInt(manager)) continue;
            isManager = true;
        }
        if (loginMember.getId().intValue() == groupTopic.getMember().getId().intValue() || loginMember.getIsAdmin() > 0 || isManager || loginMember.getId().intValue() == group.getCreator().intValue()) {
            ResponseModel responseModel = this.delete(loginMember, id);
            if (responseModel.getCode() > 0) {
                responseModel.setCode(2);
                responseModel.setUrl(request.getContextPath() + "/group/detail/" + group.getId());
            }
            return responseModel;
        }
        return new ResponseModel(-1, "\u6743\u9650\u4e0d\u8db3");
    }

    @Override
    public ResponseModel audit(Member member, int id) {
        if (member == null) {
            return new ResponseModel(-1, "\u8bf7\u5148\u767b\u5f55");
        }
        GroupTopic groupTopic = this.findById(id, member);
        if (groupTopic == null) {
            return new ResponseModel(-1, "\u5e16\u5b50\u4e0d\u5b58\u5728");
        }
        Group group = this.groupService.findById(groupTopic.getGroup().getId());
        if (group == null) {
            return new ResponseModel(-1, "\u51fa\u73b0\u5f02\u5e38");
        }
        String groupManagers = group.getManagers();
        String[] groupManagerArr = groupManagers.split(",");
        boolean isManager = false;
        for (String manager : groupManagerArr) {
            if (member.getId() != Integer.parseInt(manager)) continue;
            isManager = true;
        }
        if (member.getId().intValue() == groupTopic.getMember().getId().intValue() || member.getIsAdmin() > 0 || isManager || member.getId().intValue() == group.getCreator().intValue()) {
            if (this.groupTopicDao.audit(Integer.valueOf(id)) == 1) {
                return new ResponseModel(1, "\u5ba1\u6838\u6210\u529f");
            }
            return new ResponseModel(-1, "\u5ba1\u6838\u5931\u8d25");
        }
        return new ResponseModel(-1, "\u6743\u9650\u4e0d\u8db3");
    }

    @Override
    public ResponseModel top(Member member, int id, int top) {
        if (member == null) {
            return new ResponseModel(-1, "\u8bf7\u5148\u767b\u5f55");
        }
        GroupTopic groupTopic = this.findById(id, member);
        if (groupTopic == null) {
            return new ResponseModel(-1, "\u5e16\u5b50\u4e0d\u5b58\u5728");
        }
        Group group = this.groupService.findById(groupTopic.getGroup().getId());
        if (group == null) {
            return new ResponseModel(-1, "\u51fa\u73b0\u5f02\u5e38");
        }
        String groupManagers = group.getManagers();
        String[] groupManagerArr = groupManagers.split(",");
        boolean isManager = false;
        for (String manager : groupManagerArr) {
            if (member.getId() != Integer.parseInt(manager)) continue;
            isManager = true;
        }
        if (member.getId().intValue() == groupTopic.getMember().getId().intValue() || member.getIsAdmin() > 0 || isManager || member.getId().intValue() == group.getCreator().intValue()) {
            if (this.groupTopicDao.top(Integer.valueOf(id), Integer.valueOf(top)) == 1) {
                return new ResponseModel(1, "\u64cd\u4f5c\u6210\u529f");
            }
            return new ResponseModel(-1, "\u64cd\u4f5c\u5931\u8d25");
        }
        return new ResponseModel(-1, "\u6743\u9650\u4e0d\u8db3");
    }

    @Override
    public ResponseModel essence(Member member, int id, int essence) {
        if (member == null) {
            return new ResponseModel(-1, "\u8bf7\u5148\u767b\u5f55");
        }
        GroupTopic groupTopic = this.findById(id, member);
        if (groupTopic == null) {
            return new ResponseModel(-1, "\u5e16\u5b50\u4e0d\u5b58\u5728");
        }
        Group group = this.groupService.findById(groupTopic.getGroup().getId());
        if (group == null) {
            return new ResponseModel(-1, "\u51fa\u73b0\u5f02\u5e38");
        }
        String groupManagers = group.getManagers();
        String[] groupManagerArr = groupManagers.split(",");
        boolean isManager = false;
        for (String manager : groupManagerArr) {
            if (member.getId() != Integer.parseInt(manager)) continue;
            isManager = true;
        }
        if (member.getId().intValue() == groupTopic.getMember().getId().intValue() || member.getIsAdmin() > 0 || isManager || member.getId().intValue() == group.getCreator().intValue()) {
            if (this.groupTopicDao.essence(Integer.valueOf(id), Integer.valueOf(essence)) == 1) {
                return new ResponseModel(1, "\u64cd\u4f5c\u6210\u529f");
            }
            return new ResponseModel(-1, "\u64cd\u4f5c\u5931\u8d25");
        }
        return new ResponseModel(-1, "\u6743\u9650\u4e0d\u8db3");
    }

    @Override
    public ResponseModel favor(Member loginMember, int id) {
        GroupTopic groupTopic = this.findById(id);
        if (groupTopic != null) {
            ResponseModel responseModel = this.archiveService.favor(loginMember, groupTopic.getArchiveId());
            if (responseModel.getCode() == 0) {
                this.scoreDetailService.scoreBonus(loginMember.getId(), ScoreRuleConsts.GROUP_TOPIC_RECEIVED_LIKE, id);
            } else if (responseModel.getCode() == 1) {
                this.scoreDetailService.scoreCancelBonus(loginMember.getId(), ScoreRuleConsts.GROUP_TOPIC_RECEIVED_LIKE, id);
            }
            return responseModel;
        }
        return new ResponseModel(-1, "\u5e16\u5b50\u4e0d\u5b58\u5728");
    }

    @Override
    public List<GroupTopic> listByCustom(int gid, String sort, int num, int day, int thumbnail) {
        return this.groupTopicDao.listByCustom(gid, sort, num, day, thumbnail);
    }
}

