/*
 * Decompiled with CFR 0.152.
 */
package com.lxinet.jeesns.service.member.impl;

import com.lxinet.jeesns.common.utils.ActionUtil;
import com.lxinet.jeesns.common.utils.EmailSendUtil;
import com.lxinet.jeesns.common.utils.MemberUtil;
import com.lxinet.jeesns.common.utils.ScoreRuleConsts;
import com.lxinet.jeesns.core.dto.ResponseModel;
import com.lxinet.jeesns.core.model.Page;
import com.lxinet.jeesns.core.utils.IpUtil;
import com.lxinet.jeesns.core.utils.Md5Util;
import com.lxinet.jeesns.core.utils.RandomCodeUtil;
import com.lxinet.jeesns.core.utils.StringUtils;
import com.lxinet.jeesns.dao.member.IMemberDao;
import com.lxinet.jeesns.model.member.Member;
import com.lxinet.jeesns.model.member.ValidateCode;
import com.lxinet.jeesns.service.member.IMemberFansService;
import com.lxinet.jeesns.service.member.IMemberService;
import com.lxinet.jeesns.service.member.IScoreDetailService;
import com.lxinet.jeesns.service.member.IValidateCodeService;
import com.lxinet.jeesns.service.system.IActionLogService;
import com.lxinet.jeesns.service.system.IConfigService;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="memberService")
public class MemberServiceImpl
implements IMemberService {
    @Resource
    private IMemberDao memberDao;
    @Resource
    private IValidateCodeService validateCodeService;
    @Resource
    private IConfigService configService;
    @Resource
    private IActionLogService actionLogService;
    @Resource
    private IMemberFansService memberFansService;
    @Resource
    private IScoreDetailService scoreDetailService;

    @Override
    public ResponseModel login(Member member, HttpServletRequest request) {
        Map<String, String> config = this.configService.getConfigToMap();
        if ("0".equals(config.get("member_login_open"))) {
            return new ResponseModel(-1, "\u767b\u5f55\u529f\u80fd\u5df2\u5173\u95ed");
        }
        String password = member.getPassword();
        member.setPassword(Md5Util.getMD5Code((String)member.getPassword()));
        Member findMember = this.memberDao.login(member);
        if (findMember != null) {
            if (findMember.getStatus() == -1) {
                return new ResponseModel(-1, "\u8be5\u8d26\u6237\u5df2\u88ab\u7981\u7528");
            }
            this.memberDao.loginSuccess(findMember.getId(), IpUtil.getIpAddress((HttpServletRequest)request));
            findMember = this.findById(findMember.getId());
            MemberUtil.setLoginMember((HttpServletRequest)request, (Member)findMember);
            this.actionLogService.save(findMember.getCurrLoginIp(), findMember.getId(), ActionUtil.MEMBER_LOGIN);
            this.scoreDetailService.scoreBonus(findMember.getId(), ScoreRuleConsts.LOGIN);
            return new ResponseModel(3, "\u767b\u5f55\u6210\u529f", request.getServletContext().getContextPath() + "/member/");
        }
        this.actionLogService.save(IpUtil.getIpAddress((HttpServletRequest)request), null, ActionUtil.MEMBER_LOGIN_ERROR, "\u767b\u5f55\u7528\u6237\u540d\uff1a" + member.getName() + "\uff0c\u767b\u5f55\u5bc6\u7801\uff1a" + password);
        return new ResponseModel(-1, "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
    }

    @Override
    public Member manageLogin(Member member, HttpServletRequest request) {
        String password = member.getPassword();
        member.setPassword(Md5Util.getMD5Code((String)member.getPassword()));
        Member findMember = this.memberDao.manageLogin(member);
        if (findMember != null) {
            this.memberDao.loginSuccess(findMember.getId(), IpUtil.getIpAddress((HttpServletRequest)request));
            findMember = this.findById(findMember.getId());
        } else {
            this.actionLogService.save(IpUtil.getIpAddress((HttpServletRequest)request), null, ActionUtil.MEMBER_LOGIN_ERROR, "\u767b\u5f55\u7528\u6237\u540d\uff1a" + member.getName() + "\uff0c\u767b\u5f55\u5bc6\u7801\uff1a" + password);
        }
        return findMember;
    }

    @Override
    public Member findById(int id) {
        return (Member)this.memberDao.findById(Integer.valueOf(id));
    }

    @Override
    @Transactional
    public ResponseModel register(Member member, HttpServletRequest request) {
        if (this.memberDao.findByName(member.getName()) != null) {
            return new ResponseModel(-1, "\u8be5\u7528\u6237\u540d\u5df2\u88ab\u6ce8\u518c");
        }
        if (this.memberDao.findByEmail(member.getEmail()) != null) {
            return new ResponseModel(-1, "\u8be5\u90ae\u7bb1\u5df2\u88ab\u6ce8\u518c");
        }
        member.setRegip(IpUtil.getIpAddress((HttpServletRequest)request));
        member.setPassword(Md5Util.getMD5Code((String)member.getPassword()));
        member.setAvatar("/res/common/images/default-avatar.png");
        if (this.memberDao.register(member) == 1) {
            this.actionLogService.save(member.getRegip(), member.getId(), ActionUtil.MEMBER_REG);
            this.scoreDetailService.scoreBonus(member.getId(), ScoreRuleConsts.REG_INIT);
            return new ResponseModel(2, "\u6ce8\u518c\u6210\u529f", request.getServletContext().getContextPath() + "/member/login");
        }
        return new ResponseModel(-1, "\u6ce8\u518c\u5931\u8d25");
    }

    @Override
    public ResponseModel update(Member member) {
        if (this.memberDao.update((Object)member) == 1) {
            return new ResponseModel(3, "\u66f4\u65b0\u6210\u529f");
        }
        return new ResponseModel(-1, "\u66f4\u65b0\u5931\u8d25");
    }

    @Override
    public ResponseModel delete(int id) {
        if (this.memberDao.delete(Integer.valueOf(id)) == 1) {
            return new ResponseModel(1, "\u5220\u9664\u6210\u529f");
        }
        return new ResponseModel(-1, "\u5220\u9664\u5931\u8d25");
    }

    @Override
    public ResponseModel<Member> listByPage(Page page, String key) {
        if (StringUtils.isNotBlank((String)key)) {
            key = "%" + key.trim() + "%";
        }
        List list = this.memberDao.listByPage(page, key);
        ResponseModel model = new ResponseModel(0, page);
        model.setData((Object)list);
        return model;
    }

    @Override
    public ResponseModel<Member> managerList(Page page, String key) {
        if (StringUtils.isNotBlank((String)key)) {
            key = "%" + key.trim() + "%";
        }
        List list = this.memberDao.managerList(page, key);
        ResponseModel model = new ResponseModel(0, page);
        model.setData((Object)list);
        return model;
    }

    @Override
    public ResponseModel managerAdd(Member loginMember, String name) {
        int isAdmin = 1;
        Member findMember = this.findByName(name);
        if (findMember == null) {
            return new ResponseModel(-1, "\u4f1a\u5458[" + name + "]\u4e0d\u5b58\u5728");
        }
        if (findMember.getId() == 1 && findMember.getIsAdmin() == 1) {
            isAdmin = 2;
        }
        if (isAdmin == 1 && loginMember.getId().intValue() == findMember.getId().intValue()) {
            return new ResponseModel(-1, "\u4e0d\u80fd\u64cd\u4f5c\u81ea\u5df1\u7684\u8d26\u53f7");
        }
        if (isAdmin != 2 && findMember.getIsAdmin() > 0) {
            return new ResponseModel(-1, "\u4f1a\u5458[" + name + "]\u5df2\u7ecf\u662f\u7ba1\u7406\u5458\uff0c\u65e0\u9700\u518d\u6388\u6743");
        }
        this.memberDao.managerAddAndCancel(Integer.valueOf(isAdmin), findMember.getId());
        if (isAdmin == 2) {
            loginMember.setIsAdmin(Integer.valueOf(isAdmin));
        }
        return new ResponseModel(3, "\u64cd\u4f5c\u6210\u529f");
    }

    @Override
    public ResponseModel managerCancel(Member loginMember, int id) {
        Member findMember = this.findById(id);
        if (loginMember.getId().intValue() == findMember.getId().intValue()) {
            return new ResponseModel(-1, "\u4e0d\u80fd\u64cd\u4f5c\u81ea\u5df1\u7684\u8d26\u53f7");
        }
        if (findMember == null) {
            return new ResponseModel(-1, "\u4f1a\u5458\u4e0d\u5b58\u5728");
        }
        this.memberDao.managerAddAndCancel(Integer.valueOf(0), findMember.getId());
        return new ResponseModel(1, "\u64cd\u4f5c\u6210\u529f");
    }

    @Override
    public ResponseModel isenable(int id) {
        if (this.memberDao.isenable(Integer.valueOf(id)) == 1) {
            return new ResponseModel(1, "\u64cd\u4f5c\u6210\u529f");
        }
        return new ResponseModel(-1, "\u64cd\u4f5c\u5931\u8d25");
    }

    @Override
    public ResponseModel changepwd(Member loginMember, int id, String password) {
        if (StringUtils.isBlank((String)password)) {
            return new ResponseModel(-1, "\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (password.length() < 6) {
            return new ResponseModel(-1, "\u5bc6\u7801\u4e0d\u80fd\u5c11\u4e8e6\u4e2a\u5b57\u7b26");
        }
        password = Md5Util.getMD5Code((String)password);
        if (this.memberDao.changepwd(Integer.valueOf(id), password) == 1) {
            this.actionLogService.save(loginMember.getCurrLoginIp(), loginMember.getId(), ActionUtil.CHANGE_PWD);
            return new ResponseModel(3, "\u5bc6\u7801\u4fee\u6539\u6210\u529f");
        }
        return new ResponseModel(-1, "\u5bc6\u7801\u4fee\u6539\u5931\u8d25");
    }

    @Override
    public ResponseModel changepwd(Member loginMember, String oldPassword, String newPassword) {
        Member member;
        if (StringUtils.isBlank((String)newPassword)) {
            return new ResponseModel(-1, "\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (newPassword.length() < 6) {
            return new ResponseModel(-1, "\u5bc6\u7801\u4e0d\u80fd\u5c11\u4e8e6\u4e2a\u5b57\u7b26");
        }
        if (!(oldPassword = Md5Util.getMD5Code((String)oldPassword)).equals((member = (Member)this.memberDao.findById(loginMember.getId())).getPassword())) {
            return new ResponseModel(-1, "\u65e7\u5bc6\u7801\u9519\u8bef");
        }
        return this.changepwd(loginMember, member.getId(), newPassword);
    }

    @Override
    public ResponseModel updateAvatar(Member member, String oldAvatar, HttpServletRequest request) {
        int result = this.memberDao.updateAvatar(member.getId(), member.getAvatar());
        if (result == 1) {
            String realPath;
            File file;
            if (StringUtils.isNotEmpty((String)oldAvatar) && !"/res/common/images/default-avatar.png".equals(oldAvatar) && (file = new File(realPath = request.getServletContext().getRealPath(oldAvatar))).exists()) {
                file.delete();
            }
            return new ResponseModel(0, "\u5934\u50cf\u4fee\u6539\u6210\u529f");
        }
        return new ResponseModel(-1, "\u5934\u50cf\u4fee\u6539\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
    }

    @Override
    public ResponseModel editBaseInfo(Member member, String name, String sex, String introduce) {
        if (!StringUtils.checkNickname((String)member.getName())) {
            return new ResponseModel(-1, "\u6635\u79f0\u53ea\u80fd\u7531\u4e2d\u6587\u3001\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf(_)\u6216\u8005\u77ed\u6a2a\u7ebf(-)\u7ec4\u6210");
        }
        if (name != null && !name.equals(member.getName()) && this.findByName(name) != null) {
            return new ResponseModel(-1, "\u6635\u79f0\u5df2\u88ab\u5360\u7528\uff0c\u8bf7\u66f4\u6362\u4e00\u4e2a");
        }
        member.setName(name);
        member.setSex(sex);
        member.setIntroduce(introduce);
        if (this.memberDao.editBaseInfo(member) == 1) {
            return new ResponseModel(0, "\u4fee\u6539\u6210\u529f");
        }
        return new ResponseModel(-1, "\u4fee\u6539\u5931\u8d25");
    }

    @Override
    public ResponseModel editOtherInfo(Member loginMember, String birthday, String qq, String wechat, String contactPhone, String contactEmail, String website) {
        loginMember.setBirthday(birthday);
        loginMember.setQq(qq);
        loginMember.setWechat(wechat);
        loginMember.setContactPhone(contactPhone);
        loginMember.setContactEmail(contactEmail);
        loginMember.setWebsite(website);
        if (this.memberDao.editOtherInfo(loginMember) == 1) {
            return new ResponseModel(0, "\u4fee\u6539\u6210\u529f");
        }
        return new ResponseModel(-1, "\u4fee\u6539\u5931\u8d25");
    }

    @Override
    public Member findByName(String name) {
        return this.memberDao.findByName(name);
    }

    @Override
    public ResponseModel sendEmailActiveValidCode(Member loginMember, HttpServletRequest request) {
        if ((loginMember = this.findById(loginMember.getId())).getIsActive() == 1) {
            return new ResponseModel(-1, "\u60a8\u7684\u8d26\u53f7\u5df2\u7ecf\u6fc0\u6d3b\uff0c\u65e0\u9700\u91cd\u590d\u6fc0\u6d3b");
        }
        String randomCode = RandomCodeUtil.randomCode6();
        ValidateCode validateCode = new ValidateCode(loginMember.getEmail(), randomCode, Integer.valueOf(2));
        if (this.validateCodeService.save(validateCode) && EmailSendUtil.activeMember((HttpServletRequest)request, (String)loginMember.getEmail(), (String)randomCode)) {
            return new ResponseModel(0, "\u90ae\u4ef6\u53d1\u9001\u6210\u529f");
        }
        return new ResponseModel(-1, "\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
    }

    @Override
    @Transactional
    public ResponseModel active(Member loginMember, String randomCode, HttpServletRequest request) {
        try {
            loginMember = this.findById(loginMember.getId());
            if (loginMember.getIsActive() == 1) {
                return new ResponseModel(-1, "\u60a8\u7684\u8d26\u53f7\u5df2\u7ecf\u6fc0\u6d3b\uff0c\u65e0\u9700\u91cd\u590d\u6fc0\u6d3b");
            }
            ValidateCode validateCode = this.validateCodeService.valid(loginMember.getEmail(), randomCode, 2);
            if (validateCode == null) {
                return new ResponseModel(-1, "\u9a8c\u8bc1\u7801\u9519\u8bef");
            }
            if (this.validateCodeService.used(validateCode.getId()) && this.memberDao.active(loginMember.getId()) == 1) {
                loginMember.setIsActive(Integer.valueOf(1));
                MemberUtil.setLoginMember((HttpServletRequest)request, (Member)loginMember);
                this.scoreDetailService.scoreBonus(loginMember.getId(), ScoreRuleConsts.EMAIL_AUTHENTICATION);
                return new ResponseModel(2, "\u6fc0\u6d3b\u6210\u529f\uff0c\u6b63\u5728\u8fdb\u5165\u4f1a\u5458\u4e2d\u5fc3...", request.getContextPath() + "/member/");
            }
            return new ResponseModel(-1, "\u6fc0\u6d3b\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResponseModel(-1, "\u6fc0\u6d3b\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
        }
    }

    @Override
    public Member findByNameAndEmail(String name, String email) {
        return this.memberDao.findByNameAndEmail(name, email);
    }

    @Override
    public ResponseModel forgetpwd(String name, String email, HttpServletRequest request) {
        Member member = this.findByNameAndEmail(name, email);
        if (member == null) {
            return new ResponseModel(-1, "\u4f1a\u5458\u4e0d\u5b58\u5728");
        }
        String randomCode = RandomCodeUtil.uuid();
        ValidateCode validateCode = new ValidateCode(email, randomCode, Integer.valueOf(1));
        if (this.validateCodeService.save(validateCode) && EmailSendUtil.forgetpwd((HttpServletRequest)request, (String)email, (String)randomCode)) {
            return new ResponseModel(0, "\u90ae\u4ef6\u53d1\u9001\u6210\u529f");
        }
        return new ResponseModel(-1, "\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
    }

    @Override
    @Transactional
    public ResponseModel resetpwd(String email, String token, String password, HttpServletRequest request) {
        Member member = this.memberDao.findByEmail(email);
        if (member == null) {
            return new ResponseModel(-1, "\u4f1a\u5458\u4e0d\u5b58\u5728");
        }
        ValidateCode validateCode = this.validateCodeService.valid(email, token, 1);
        if (validateCode == null) {
            return new ResponseModel(-1, "\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        password = Md5Util.getMD5Code((String)password);
        if (this.memberDao.changepwd(member.getId(), password) == 1) {
            this.validateCodeService.used(validateCode.getId());
            this.actionLogService.save(IpUtil.getIpAddress((HttpServletRequest)request), member.getId(), ActionUtil.FIND_PWD);
            return new ResponseModel(2, "\u5bc6\u7801\u91cd\u7f6e\u6210\u529f", request.getContextPath() + "/member/login");
        }
        return new ResponseModel(-1, "\u5bc6\u7801\u91cd\u7f6e\u5931\u8d25");
    }

    @Override
    @Transactional
    public ResponseModel follows(Member loginMember, Integer followWhoId) {
        if (loginMember == null) {
            return new ResponseModel(-1, "\u8bf7\u5148\u767b\u5f55");
        }
        if (this.findById(followWhoId) == null) {
            return new ResponseModel(-1, "\u5173\u6ce8\u7684\u4f1a\u5458\u4e0d\u5b58\u5728");
        }
        if (loginMember.getId().intValue() == followWhoId.intValue()) {
            return new ResponseModel(-1, "\u4e0d\u80fd\u5173\u6ce8\u81ea\u5df1");
        }
        if (this.memberFansService.find(loginMember.getId(), followWhoId) == null) {
            this.memberFansService.save(loginMember.getId(), followWhoId);
            this.memberDao.follows(loginMember.getId());
            this.memberDao.fans(followWhoId);
            return new ResponseModel(1, "\u5173\u6ce8\u6210\u529f");
        }
        this.memberFansService.delete(loginMember.getId(), followWhoId);
        this.memberDao.follows(loginMember.getId());
        this.memberDao.fans(followWhoId);
        return new ResponseModel(0, "\u53d6\u6d88\u5173\u6ce8\u6210\u529f");
    }

    @Override
    public ResponseModel isFollowed(Member loginMember, Integer followWhoId) {
        int loginMemberId = 0;
        if (loginMember != null) {
            loginMemberId = loginMember.getId();
        }
        if (this.memberFansService.find(loginMemberId, followWhoId) == null) {
            return new ResponseModel(0, "\u672a\u5173\u6ce8");
        }
        return new ResponseModel(1, "\u5df2\u5173\u6ce8");
    }

    @Override
    public List<Member> listContactMemberIds(Page page, Integer memberId) {
        List list = this.memberDao.listContactMemberIds(page, memberId);
        return list;
    }

    @Override
    public ResponseModel<Member> listContactMembers(Page page, Integer memberId) {
        List<Member> memberIdList = this.listContactMemberIds(page, memberId);
        List list = new ArrayList();
        if (memberIdList.size() > 0) {
            ArrayList<Integer> idList = new ArrayList<Integer>();
            String idString = "";
            for (Member member : memberIdList) {
                idList.add(member.getId());
                idString = idString + member.getId() + ",";
            }
            if (idString.length() > 0) {
                idString = idString.substring(0, idString.length() - 1);
            }
            list = this.memberDao.listContactMembers(memberId, idList, idString);
        }
        ResponseModel model = new ResponseModel(0, page);
        model.setData(list);
        return model;
    }

    @Override
    public boolean updateScore(Integer score, Integer memberId) {
        return this.memberDao.updateScore(score, memberId) == 1;
    }
}

