/*
 * Decompiled with CFR 0.152.
 */
package com.lxinet.jeesns.service.member.impl;

import com.lxinet.jeesns.core.dto.ResponseModel;
import com.lxinet.jeesns.core.model.Page;
import com.lxinet.jeesns.dao.member.IScoreDetailDao;
import com.lxinet.jeesns.model.member.ScoreDetail;
import com.lxinet.jeesns.model.system.ScoreRule;
import com.lxinet.jeesns.service.member.IMemberService;
import com.lxinet.jeesns.service.member.IScoreDetailService;
import com.lxinet.jeesns.service.system.IScoreRuleService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ScoreDetailServiceImpl
implements IScoreDetailService {
    @Resource
    private IScoreDetailDao scoreDetailDao;
    @Resource
    private IScoreRuleService scoreRuleService;
    @Resource
    private IMemberService memberService;

    @Override
    public ResponseModel<ScoreDetail> list(Page page, Integer memberId) {
        List list = this.scoreDetailDao.listByPage(page, memberId);
        ResponseModel model = new ResponseModel(0, page);
        model.setData((Object)list);
        return model;
    }

    @Override
    public ResponseModel save(ScoreDetail scoreDetail) {
        if (this.scoreDetailDao.save((Object)scoreDetail) > 0) {
            return new ResponseModel(0);
        }
        return new ResponseModel(-1, "\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public boolean canBonus(int memberId, int scoreRuleId, String type) {
        List list = this.scoreDetailDao.canBonus(Integer.valueOf(memberId), Integer.valueOf(scoreRuleId), type);
        return list.size() == 0;
    }

    @Override
    public ScoreDetail findByForeignAndRule(int memberId, int scoreRuleId, int forgignId) {
        return this.scoreDetailDao.findByForeignAndRule(Integer.valueOf(memberId), Integer.valueOf(scoreRuleId), Integer.valueOf(forgignId));
    }

    @Override
    public void cancel(int scoreDetailId) {
        this.scoreDetailDao.cancel(Integer.valueOf(scoreDetailId));
    }

    @Override
    public void scoreBonus(int memberId, int scoreRuleId) {
        this.scoreBonus(memberId, scoreRuleId, 0);
    }

    @Override
    public void scoreBonus(int memberId, int scoreRuleId, int foreignId) {
        ScoreRule scoreRule = this.scoreRuleService.findById(scoreRuleId);
        if (scoreRule != null && scoreRule.getScore() != 0) {
            String type = scoreRule.getType();
            boolean canBonus = true;
            if (!"unlimite".equals(type)) {
                canBonus = this.canBonus(memberId, scoreRuleId, type);
            }
            if (canBonus && this.findByForeignAndRule(memberId, scoreRuleId, foreignId) == null) {
                this.memberService.updateScore(scoreRule.getScore(), memberId);
                ScoreDetail scoreDetail = new ScoreDetail();
                scoreDetail.setType(Integer.valueOf(1));
                scoreDetail.setMemberId(Integer.valueOf(memberId));
                scoreDetail.setForeignId(Integer.valueOf(foreignId));
                scoreDetail.setScore(scoreRule.getScore());
                String remark = scoreRule.getName();
                if (foreignId > 0) {
                    remark = remark + " #" + foreignId;
                }
                scoreDetail.setRemark(remark);
                scoreDetail.setScoreRuleId(Integer.valueOf(scoreRuleId));
                this.save(scoreDetail);
            }
        }
    }

    @Override
    public void scoreCancelBonus(int memberId, int scoreRuleId, int foreignId) {
        ScoreDetail scoreDetail = this.findByForeignAndRule(memberId, scoreRuleId, foreignId);
        if (scoreDetail != null) {
            this.cancel(scoreDetail.getId());
            this.memberService.updateScore(-scoreDetail.getScore().intValue(), memberId);
            ScoreDetail scoreDetailCancel = new ScoreDetail();
            scoreDetailCancel.setType(Integer.valueOf(2));
            scoreDetailCancel.setMemberId(Integer.valueOf(memberId));
            scoreDetailCancel.setForeignId(Integer.valueOf(foreignId));
            scoreDetailCancel.setScore(Integer.valueOf(-scoreDetail.getScore().intValue()));
            scoreDetailCancel.setRemark("\u64a4\u9500\u79ef\u5206\u5956\u52b1 #" + scoreDetail.getId());
            scoreDetailCancel.setScoreRuleId(Integer.valueOf(scoreRuleId));
            this.save(scoreDetailCancel);
        }
    }
}

