/*
 * Decompiled with CFR 0.152.
 */
package com.lxinet.jeesns.service.weibo.impl;

import com.lxinet.jeesns.common.utils.ActionUtil;
import com.lxinet.jeesns.common.utils.ScoreRuleConsts;
import com.lxinet.jeesns.core.dto.ResponseModel;
import com.lxinet.jeesns.core.model.Page;
import com.lxinet.jeesns.core.utils.StringUtils;
import com.lxinet.jeesns.dao.weibo.IWeiboCommentDao;
import com.lxinet.jeesns.model.member.Member;
import com.lxinet.jeesns.model.weibo.Weibo;
import com.lxinet.jeesns.model.weibo.WeiboComment;
import com.lxinet.jeesns.service.member.IScoreDetailService;
import com.lxinet.jeesns.service.system.IActionLogService;
import com.lxinet.jeesns.service.weibo.IWeiboCommentService;
import com.lxinet.jeesns.service.weibo.IWeiboService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="weiboCommentService")
public class WeiboCommentServiceImpl
implements IWeiboCommentService {
    @Resource
    private IWeiboCommentDao weiboCommentDao;
    @Resource
    private IWeiboService weiboService;
    @Resource
    private IActionLogService actionLogService;
    @Resource
    private IScoreDetailService scoreDetailService;

    @Override
    public WeiboComment findById(int id) {
        WeiboComment weiboComment = (WeiboComment)this.weiboCommentDao.findById(Integer.valueOf(id));
        return weiboComment;
    }

    @Override
    public ResponseModel save(Member loginMember, String content, Integer weiboId, Integer weiboCommentId) {
        Weibo weibo = this.weiboService.findById(weiboId, loginMember.getId());
        if (weibo == null) {
            return new ResponseModel(-1, "\u5fae\u535a\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isEmpty((String)content)) {
            return new ResponseModel(-1, "\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (content.length() > 500) {
            return new ResponseModel(-1, "\u8bc4\u8bba\u5185\u5bb9\u4e0d\u80fd\u8d85\u8fc7500\u957f\u5ea6");
        }
        WeiboComment weiboComment = new WeiboComment();
        weiboComment.setMemberId(loginMember.getId());
        weiboComment.setWeiboId(weiboId);
        weiboComment.setContent(content);
        weiboComment.setCommentId(weiboCommentId);
        int result = this.weiboCommentDao.save((Object)weiboComment);
        if (result == 1) {
            this.scoreDetailService.scoreBonus(loginMember.getId(), ScoreRuleConsts.COMMENT_WEIBO, weiboComment.getId());
            return new ResponseModel(1, "\u8bc4\u8bba\u6210\u529f");
        }
        return new ResponseModel(-1, "\u8bc4\u8bba\u5931\u8d25");
    }

    @Override
    public ResponseModel listByWeibo(Page page, int weiboId) {
        List list = this.weiboCommentDao.listByWeibo(page, Integer.valueOf(weiboId));
        ResponseModel model = new ResponseModel(0, page);
        model.setData((Object)list);
        return model;
    }

    @Override
    public void deleteByWeibo(Integer weiboId) {
        this.weiboCommentDao.deleteByWeibo(weiboId);
    }

    @Override
    public ResponseModel delete(Member loginMember, int id) {
        WeiboComment weiboComment = this.findById(id);
        if (weiboComment == null) {
            return new ResponseModel(-1, "\u8bc4\u8bba\u4e0d\u5b58\u5728");
        }
        int result = this.weiboCommentDao.delete(Integer.valueOf(id));
        if (result == 1) {
            this.actionLogService.save(loginMember.getCurrLoginIp(), loginMember.getId(), ActionUtil.DELETE_WEIBO_COMMENT, "ID\uff1a" + weiboComment.getId() + "\u5185\u5bb9\uff1a" + weiboComment.getContent());
            return new ResponseModel(1, "\u5220\u9664\u6210\u529f");
        }
        return new ResponseModel(-1, "\u5220\u9664\u5931\u8d25");
    }
}

