/*
 * Decompiled with CFR 0.152.
 */
package com.lxinet.jeesns.service.weibo.impl;

import com.lxinet.jeesns.common.utils.ActionLogType;
import com.lxinet.jeesns.common.utils.ActionUtil;
import com.lxinet.jeesns.common.utils.ScoreRuleConsts;
import com.lxinet.jeesns.core.dto.ResponseModel;
import com.lxinet.jeesns.core.model.Page;
import com.lxinet.jeesns.core.utils.StringUtils;
import com.lxinet.jeesns.dao.weibo.IWeiboDao;
import com.lxinet.jeesns.model.member.Member;
import com.lxinet.jeesns.model.weibo.Weibo;
import com.lxinet.jeesns.service.common.IPictureService;
import com.lxinet.jeesns.service.member.IScoreDetailService;
import com.lxinet.jeesns.service.system.IActionLogService;
import com.lxinet.jeesns.service.weibo.IWeiboFavorService;
import com.lxinet.jeesns.service.weibo.IWeiboService;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="weiboService")
public class WeiboServiceImpl
implements IWeiboService {
    @Resource
    private IWeiboDao weiboDao;
    @Resource
    private IWeiboFavorService weiboFavorService;
    @Resource
    private IActionLogService actionLogService;
    @Resource
    private IPictureService pictureService;
    @Resource
    private IScoreDetailService scoreDetailService;

    @Override
    public Weibo findById(int id, int memberId) {
        Weibo weibo = this.weiboDao.findById(Integer.valueOf(id), Integer.valueOf(memberId));
        return weibo;
    }

    @Override
    @Transactional
    public ResponseModel save(HttpServletRequest request, Member loginMember, String content, String pictures) {
        if ("0".equals(request.getServletContext().getAttribute("weibo_post".toUpperCase()))) {
            return new ResponseModel(-1, "\u5fae\u535a\u5df2\u5173\u95ed");
        }
        if (StringUtils.isEmpty((String)content)) {
            return new ResponseModel(-1, "\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (content.length() > Integer.parseInt((String)request.getServletContext().getAttribute("weibo_post_maxcontent".toUpperCase()))) {
            return new ResponseModel(-1, "\u5185\u5bb9\u4e0d\u80fd\u8d85\u8fc7" + request.getServletContext().getAttribute("weibo_post_maxcontent".toUpperCase()) + "\u5b57");
        }
        Weibo weibo = new Weibo();
        weibo.setMemberId(loginMember.getId());
        weibo.setContent(content);
        weibo.setStatus(Integer.valueOf(1));
        if (StringUtils.isEmpty((String)pictures)) {
            weibo.setType(Integer.valueOf(0));
        } else {
            weibo.setType(Integer.valueOf(1));
        }
        if (this.weiboDao.save(weibo) == 1) {
            this.pictureService.update(weibo.getId(), pictures);
            this.actionLogService.save(loginMember.getCurrLoginIp(), loginMember.getId(), ActionUtil.POST_WEIBO, "", ActionLogType.WEIBO.getValue(), weibo.getId());
            this.scoreDetailService.scoreBonus(loginMember.getId(), ScoreRuleConsts.RELEASE_WEIBO, weibo.getId());
            return new ResponseModel(1, "\u53d1\u5e03\u6210\u529f");
        }
        return new ResponseModel(-1, "\u53d1\u5e03\u5931\u8d25");
    }

    @Override
    public ResponseModel<Weibo> listByPage(Page page, int memberId, int loginMemberId, String key) {
        if (StringUtils.isNotBlank((String)key)) {
            key = "%" + key.trim() + "%";
        }
        List list = this.weiboDao.listByPage(page, memberId, loginMemberId, key);
        ResponseModel model = new ResponseModel(0, page);
        model.setData((Object)list);
        return model;
    }

    @Override
    @Transactional
    public ResponseModel delete(HttpServletRequest request, Member loginMember, int id) {
        Weibo weibo = this.findById(id, loginMember.getId());
        if (weibo == null) {
            return new ResponseModel(-1, "\u5fae\u535a\u4e0d\u5b58\u5728");
        }
        this.weiboDao.delete(id);
        this.scoreDetailService.scoreCancelBonus(loginMember.getId(), ScoreRuleConsts.RELEASE_WEIBO, id);
        this.pictureService.delete(request, id);
        this.actionLogService.save(loginMember.getCurrLoginIp(), loginMember.getId(), ActionUtil.DELETE_WEIBO, "ID\uff1a" + weibo.getId() + "\uff0c\u5185\u5bb9\uff1a" + weibo.getContent());
        return new ResponseModel(1, "\u64cd\u4f5c\u6210\u529f");
    }

    @Override
    @Transactional
    public ResponseModel userDelete(HttpServletRequest request, Member loginMember, int id) {
        if (loginMember == null) {
            return new ResponseModel(-1, "\u8bf7\u5148\u767b\u5f55");
        }
        Weibo weibo = this.findById(id, loginMember.getId());
        if (weibo == null) {
            return new ResponseModel(-1, "\u5fae\u535a\u4e0d\u5b58\u5728");
        }
        if (loginMember.getIsAdmin() == 0 && loginMember.getId().intValue() != weibo.getMember().getId().intValue()) {
            return new ResponseModel(-1, "\u6ca1\u6709\u6743\u9650");
        }
        return this.delete(request, loginMember, id);
    }

    @Override
    public List<Weibo> hotList(int loginMemberId) {
        List hotList = this.weiboDao.hotList(loginMemberId);
        return hotList;
    }

    @Override
    @Transactional
    public ResponseModel favor(Member loginMember, int weiboId) {
        ResponseModel responseModel;
        if (this.weiboFavorService.find(weiboId, loginMember.getId()) == null) {
            this.weiboDao.favor(Integer.valueOf(weiboId), Integer.valueOf(1));
            this.weiboFavorService.save(weiboId, loginMember.getId());
            String message = "\u70b9\u8d5e\u6210\u529f";
            responseModel = new ResponseModel(0, message);
            this.scoreDetailService.scoreBonus(loginMember.getId(), ScoreRuleConsts.WEIBO_RECEIVED_THUMBUP, weiboId);
        } else {
            int num = this.weiboDao.favor(Integer.valueOf(weiboId), Integer.valueOf(-1));
            this.weiboFavorService.delete(weiboId, loginMember.getId());
            String message = "\u53d6\u6d88\u8d5e\u6210\u529f";
            this.scoreDetailService.scoreCancelBonus(loginMember.getId(), ScoreRuleConsts.WEIBO_RECEIVED_THUMBUP, weiboId);
            responseModel = new ResponseModel(1, message);
        }
        Weibo findWeibo = this.findById(weiboId, loginMember.getId());
        responseModel.setData((Object)findWeibo.getFavor());
        return responseModel;
    }

    @Override
    public List<Weibo> listByCustom(int loginMemberId, String sort, int num, int day) {
        return this.weiboDao.listByCustom(Integer.valueOf(loginMemberId), sort, num, day);
    }
}

