/*
 * Decompiled with CFR 0.152.
 */
package com.lxinet.jeesns.core.utils;

import com.lxinet.jeesns.core.utils.StringUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HtmlUtil {
    private static final String REGEX_SCRIPT = "<script[^>]*?>[\\s\\S]*?<\\/script>";
    private static final String REGEX_STYLE = "<style[^>]*?>[\\s\\S]*?<\\/style>";
    private static final String REGEX_HTML = "<[^>]+>";
    private static final String REGEX_SPACE = "\\s*|\t|\r|\n";

    private HtmlUtil() {
    }

    public static String delHTMLTag(String htmlStr) {
        if (StringUtils.isNotEmpty(htmlStr)) {
            Pattern pScript = Pattern.compile(REGEX_SCRIPT, 2);
            Matcher mScript = pScript.matcher(htmlStr);
            htmlStr = mScript.replaceAll("");
            Pattern pStyle = Pattern.compile(REGEX_STYLE, 2);
            Matcher mStyle = pStyle.matcher(htmlStr);
            htmlStr = mStyle.replaceAll("");
            Pattern pHtml = Pattern.compile(REGEX_HTML, 2);
            Matcher mHtml = pHtml.matcher(htmlStr);
            htmlStr = mHtml.replaceAll("");
            Pattern pSpace = Pattern.compile(REGEX_SPACE, 2);
            Matcher mSpace = pSpace.matcher(htmlStr);
            htmlStr = mSpace.replaceAll("");
            return htmlStr.trim();
        }
        return htmlStr;
    }
}

