/*
 * Decompiled with CFR 0.152.
 */
package com.lxinet.jeesns.core.utils;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class ImageUtil {
    private static String DEFAULT_PREVFIX = "thumb_";
    private static Boolean DEFAULT_FORCE = false;
    private static int DEFAULT_WIDTH = 160;
    private static int DEFAULT_HEIGHT = 160;
    private File targetFile;

    public String dealImage(File imgFile) {
        this.thumbnailImage(imgFile);
        return this.cutImage(this.targetFile);
    }

    private String thumbnailImage(File imgFile, int w, int h, String prevfix, boolean force) {
        String thumbPath = "";
        String fileName = "";
        if (imgFile.exists()) {
            try {
                String types = Arrays.toString(ImageIO.getReaderFormatNames());
                String suffix = null;
                if (imgFile.getName().indexOf(".") > -1) {
                    suffix = imgFile.getName().substring(imgFile.getName().lastIndexOf(".") + 1);
                }
                if (suffix == null || types.toLowerCase().indexOf(suffix.toLowerCase()) < 0) {
                    return thumbPath;
                }
                BufferedImage img = ImageIO.read(imgFile);
                if (!force) {
                    int height;
                    int width = ((Image)img).getWidth(null);
                    if ((double)width * 1.0 / (double)w < (double)(height = ((Image)img).getHeight(null)) * 1.0 / (double)h) {
                        if (width > w) {
                            h = Integer.parseInt(new DecimalFormat("0").format((double)(height * w) / ((double)width * 1.0)));
                        } else {
                            w = width;
                        }
                    } else if (height > h) {
                        w = Integer.parseInt(new DecimalFormat("0").format((double)(width * h) / ((double)height * 1.0)));
                    } else {
                        h = height;
                    }
                }
                BufferedImage bi = new BufferedImage(w, h, 1);
                Graphics g = bi.getGraphics();
                g.drawImage(img, 0, 0, w, h, Color.LIGHT_GRAY, null);
                g.dispose();
                fileName = prevfix + imgFile.getName();
                String p = imgFile.getPath();
                thumbPath = p.substring(0, p.lastIndexOf(File.separator)) + File.separator + fileName;
                this.targetFile = new File(thumbPath);
                ImageIO.write((RenderedImage)bi, suffix, this.targetFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return fileName;
    }

    private String thumbnailImage(File imgFile, int w, int h, boolean force) {
        return this.thumbnailImage(imgFile, w, h, DEFAULT_PREVFIX, force);
    }

    private String thumbnailImage(File imgFile) {
        return this.thumbnailImage(imgFile, DEFAULT_WIDTH, DEFAULT_HEIGHT, DEFAULT_FORCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String cutImage(File imgFile, int w, int h) {
        FileInputStream is = null;
        ImageInputStream iis = null;
        String fileName = "";
        String suffix = "";
        String thumbPath = "";
        try {
            int y;
            int x;
            String types = Arrays.toString(ImageIO.getReaderFormatNames());
            if (imgFile.getName().indexOf(".") > -1) {
                suffix = imgFile.getName().substring(imgFile.getName().lastIndexOf(".") + 1);
            }
            if (suffix == null || types.toLowerCase().indexOf(suffix.toLowerCase()) < 0) {
                String string = thumbPath;
                return string;
            }
            is = new FileInputStream(imgFile);
            BufferedImage img = ImageIO.read(imgFile);
            int width = ((Image)img).getWidth(null);
            int height = ((Image)img).getHeight(null);
            if (width > w) {
                x = (width - w) / 2;
            } else {
                x = 0;
                w = width;
            }
            if (height > h) {
                y = (height - h) / 2;
            } else {
                y = 0;
                h = height;
            }
            Iterator<ImageReader> it = ImageIO.getImageReadersByFormatName(suffix);
            ImageReader reader = it.next();
            iis = ImageIO.createImageInputStream(is);
            reader.setInput(iis, true);
            ImageReadParam param = reader.getDefaultReadParam();
            Rectangle rect = new Rectangle(x, y, w, h);
            param.setSourceRegion(rect);
            BufferedImage bi = reader.read(0, param);
            fileName = imgFile.getName();
            String p = imgFile.getPath();
            thumbPath = p.substring(0, p.lastIndexOf(File.separator)) + File.separator + fileName;
            ImageIO.write((RenderedImage)bi, suffix, new File(thumbPath));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (iis != null) {
                try {
                    iis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return fileName;
    }

    private String cutImage(File imgFile) {
        return this.cutImage(imgFile, DEFAULT_WIDTH, DEFAULT_HEIGHT);
    }
}

