/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.ExtJSONParser;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.JavaBeanMapping;
import com.alibaba.fastjson.parser.SymbolTable;
import com.alibaba.fastjson.parser.deserializer.DefaultObjectDeserializer;
import com.alibaba.fastjson.parser.deserializer.IntegerDeserializer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.parser.deserializer.StringDeserializer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExtJSONParser
extends DefaultJSONParser
implements ExtJSONParser {
    private JavaBeanMapping mapping;
    private boolean ignoreNotMatch = true;
    private DefaultObjectDeserializer derializer = new DefaultObjectDeserializer();
    private static final Set<Class<?>> primitiveClasses = new HashSet();

    public DefaultExtJSONParser(String input) {
        this(input, JavaBeanMapping.getGlobalInstance());
    }

    public DefaultExtJSONParser(String input, JavaBeanMapping mapping) {
        super(input);
        this.mapping = mapping;
    }

    public DefaultExtJSONParser(String input, SymbolTable symbolTable) {
        this(input, symbolTable, JavaBeanMapping.getGlobalInstance());
    }

    public DefaultExtJSONParser(String input, SymbolTable symbolTable, JavaBeanMapping mapping) {
        super(input, symbolTable);
        this.mapping = mapping;
    }

    public DefaultExtJSONParser(String input, SymbolTable symbolTable, int features) {
        this(input, symbolTable, features, JavaBeanMapping.getGlobalInstance());
    }

    public DefaultExtJSONParser(char[] input, int length, SymbolTable symbolTable, int features) {
        this(input, length, symbolTable, features, JavaBeanMapping.getGlobalInstance());
    }

    public DefaultExtJSONParser(String input, SymbolTable symbolTable, int features, JavaBeanMapping mapping) {
        super(input, symbolTable, features);
        this.mapping = mapping;
    }

    public DefaultExtJSONParser(Object input, JSONLexer lexer, SymbolTable symbolTable, JavaBeanMapping mapping) {
        super(input, lexer, symbolTable);
        this.mapping = mapping;
    }

    public DefaultExtJSONParser(char[] input, int length, SymbolTable symbolTable, int features, JavaBeanMapping mapping) {
        super(input, length, symbolTable, features);
        this.mapping = mapping;
    }

    public JavaBeanMapping getMapping() {
        return this.mapping;
    }

    public void setMapping(JavaBeanMapping mapping) {
        this.mapping = mapping;
    }

    public boolean isIgnoreNotMatch() {
        return this.ignoreNotMatch;
    }

    public void setIgnoreNotMatch(boolean ignoreNotMatch) {
        this.ignoreNotMatch = ignoreNotMatch;
    }

    @Override
    public <T> T parseObject(Class<T> clazz) {
        return this.parseObject((Type)clazz);
    }

    @Override
    public <T> T parseObject(Type type) {
        if (this.lexer.token() == 8) {
            this.lexer.nextToken();
            return null;
        }
        ObjectDeserializer derializer = this.mapping.getDeserializer(type);
        try {
            if (derializer != null) {
                return derializer.deserialze(this, type);
            }
            return this.derializer.deserialze(this, type);
        }
        catch (JSONException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new JSONException(e.getMessage(), e);
        }
    }

    public <T> List<T> parseArray(Class<T> clazz) {
        ArrayList array = new ArrayList();
        this.parseArray(clazz, array);
        return array;
    }

    @Override
    public void parseArray(Class<?> clazz, Collection array) {
        this.parseArray((Type)clazz, array);
    }

    @Override
    public void parseArray(Type type, Collection array) {
        if (this.lexer.token() != 14) {
            throw new JSONException("exepct '[', but " + this.lexer.token());
        }
        ObjectDeserializer deserializer = null;
        if (Integer.TYPE == type) {
            deserializer = IntegerDeserializer.instance;
            this.lexer.nextToken(2);
        } else if (String.class == type) {
            deserializer = StringDeserializer.instance;
            this.lexer.nextToken(4);
        } else {
            deserializer = this.mapping.getDeserializer(type);
            this.lexer.nextToken(deserializer.getFastMatchToken());
        }
        while (true) {
            Object val;
            if (this.isEnabled(Feature.AllowArbitraryCommas)) {
                while (this.lexer.token() == 16) {
                    this.lexer.nextToken();
                }
            }
            if (this.lexer.token() == 15) break;
            if (Integer.TYPE == type) {
                val = IntegerDeserializer.deserialze(this);
                array.add(val);
            } else if (String.class == type) {
                String value;
                if (this.lexer.token() == 4) {
                    value = this.lexer.stringVal();
                    this.lexer.nextToken(16);
                } else {
                    Object obj = this.parse();
                    value = obj == null ? null : obj.toString();
                }
                array.add(value);
            } else {
                val = deserializer.deserialze(this, type);
                array.add(val);
            }
            if (this.lexer.token() != 16) continue;
            this.lexer.nextToken(deserializer.getFastMatchToken());
        }
        if (this.lexer.token() != 15) {
            throw new JSONException("exepct ']', but " + this.lexer.token());
        }
        this.lexer.nextToken(16);
    }

    @Override
    public void parseObject(Object object) {
        this.derializer.parseObject(this, object);
    }

    public Object parseArrayWithType(Type collectionType) {
        Type upperBoundType;
        WildcardType wildcardType;
        if (this.lexer.token() == 8) {
            this.lexer.nextToken();
            return null;
        }
        Type actualTypeArgument = ((ParameterizedType)collectionType).getActualTypeArguments()[0];
        if (actualTypeArgument instanceof Class) {
            ArrayList array = new ArrayList();
            this.parseArray((Class)actualTypeArgument, array);
            return array;
        }
        if (actualTypeArgument instanceof WildcardType && (wildcardType = (WildcardType)actualTypeArgument).getUpperBounds().length == 1 && (upperBoundType = wildcardType.getUpperBounds()[0]) instanceof Class) {
            if (Object.class.equals((Object)upperBoundType)) {
                if (wildcardType.getLowerBounds().length == 0) {
                    return this.parse();
                }
                throw new JSONException("not support type : " + collectionType);
            }
            ArrayList array = new ArrayList();
            this.parseArray((Class)upperBoundType, array);
            return array;
        }
        if (actualTypeArgument instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)actualTypeArgument;
            Type[] bounds = typeVariable.getBounds();
            if (bounds.length != 1) {
                throw new JSONException("not support : " + typeVariable);
            }
            Type boundType = bounds[0];
            if (boundType instanceof Class) {
                ArrayList array = new ArrayList();
                this.parseArray((Class)boundType, array);
                return array;
            }
        }
        if (actualTypeArgument instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)actualTypeArgument;
            ArrayList array = new ArrayList();
            this.parseArray((Class)parameterizedType.getRawType(), array);
            return array;
        }
        throw new JSONException("TODO : " + collectionType);
    }

    static {
        primitiveClasses.add(Boolean.TYPE);
        primitiveClasses.add(Byte.TYPE);
        primitiveClasses.add(Short.TYPE);
        primitiveClasses.add(Integer.TYPE);
        primitiveClasses.add(Long.TYPE);
        primitiveClasses.add(Float.TYPE);
        primitiveClasses.add(Double.TYPE);
        primitiveClasses.add(Boolean.class);
        primitiveClasses.add(Byte.class);
        primitiveClasses.add(Short.class);
        primitiveClasses.add(Integer.class);
        primitiveClasses.add(Long.class);
        primitiveClasses.add(Float.class);
        primitiveClasses.add(Double.class);
        primitiveClasses.add(BigInteger.class);
        primitiveClasses.add(BigDecimal.class);
        primitiveClasses.add(String.class);
    }
}

