/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultExtJSONParser;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import java.io.StringWriter;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppendableDeserializer
implements ObjectDeserializer {
    public static final AppendableDeserializer instance = new AppendableDeserializer();

    @Override
    public <T> T deserialze(DefaultExtJSONParser parser, Type type) {
        Object value = parser.parse();
        if (value == null) {
            return null;
        }
        if (type == Appendable.class || type == StringBuilder.class) {
            StringBuilder buf = new StringBuilder();
            buf.append(value.toString());
            return (T)buf;
        }
        if (type == StringBuffer.class) {
            StringBuffer buf = new StringBuffer();
            buf.append(value.toString());
            return (T)buf;
        }
        if (type == StringWriter.class) {
            StringWriter buf = new StringWriter();
            buf.append(value.toString());
            return (T)buf;
        }
        try {
            Class clazz = (Class)type;
            Appendable inst = (Appendable)clazz.newInstance();
            inst.append(value.toString());
            return (T)inst;
        }
        catch (Exception e) {
            throw new JSONException(e.getMessage(), e);
        }
    }

    @Override
    public int getFastMatchToken() {
        return 4;
    }
}

