/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultExtJSONParser;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FieldDeserializer
implements Comparable<FieldDeserializer> {
    protected final Method method;
    protected final Class<?> clazz;
    protected final Class<?> fieldClass;
    protected final Type fieldType;
    protected int ordinal;
    protected String fieldName;
    protected char[] fiedNameChars;

    public FieldDeserializer(Class<?> clazz, Method method) {
        this.clazz = clazz;
        this.method = method;
        this.fieldClass = method.getParameterTypes()[0];
        this.fieldType = method.getGenericParameterTypes()[0];
    }

    @Override
    public int compareTo(FieldDeserializer o) {
        return this.fieldName.compareTo(o.fieldName);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
        String prefix = "\"" + fieldName + "\":";
        this.fiedNameChars = prefix.toCharArray();
    }

    public char[] getFiedNameChars() {
        return this.fiedNameChars;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Class<?> getFieldClass() {
        return this.fieldClass;
    }

    public Type getFieldType() {
        return this.fieldType;
    }

    public abstract void parseField(DefaultExtJSONParser var1, Object var2);

    public abstract int getFastMatchToken();

    public void setValue(Object object, boolean value) {
        this.setValue(object, (Object)value);
    }

    public void setValue(Object object, int value) {
        this.setValue(object, (Object)value);
    }

    public void setValue(Object object, long value) {
        this.setValue(object, (Object)value);
    }

    public void setValue(Object object, String value) {
        this.setValue(object, (Object)value);
    }

    public void setValue(Object object, Object value) {
        try {
            this.method.invoke(object, value);
        }
        catch (Exception e) {
            throw new JSONException("set property error, " + this.method.toString(), e);
        }
    }

    public String toString() {
        return this.method.toString();
    }
}

