/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.asm.ClassWriter;
import com.alibaba.fastjson.asm.Label;
import com.alibaba.fastjson.asm.MethodVisitor;
import com.alibaba.fastjson.asm.Opcodes;
import com.alibaba.fastjson.parser.JavaBeanMapping;
import com.alibaba.fastjson.serializer.FilterUtils;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.PropertyInfo;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.JSONASMUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASMSerializerFactory
implements Opcodes {
    private ASMClassLoader classLoader = new ASMClassLoader();
    private final AtomicLong seed = new AtomicLong();

    public ObjectSerializer createJavaBeanSerializer(Class<?> clazz) throws Exception {
        return this.createJavaBeanSerializer(clazz, null);
    }

    public String getGenClassName(Class<?> clazz) {
        return "Serializer_" + this.seed.incrementAndGet();
    }

    public ObjectSerializer createJavaBeanSerializer(Class<?> clazz, Map<String, String> aliasMap) throws Exception {
        String className = this.getGenClassName(clazz);
        this.classLoader.getClasses().put(className, null);
        ClassWriter cw = new ClassWriter();
        cw.visit(49, 33, className, "java/lang/Object", new String[]{"com/alibaba/fastjson/serializer/ObjectSerializer"});
        MethodVisitor mw = cw.visitMethod(1, "<init>", "()V", null, null);
        mw.visitVarInsn(25, 0);
        mw.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        mw.visitInsn(177);
        mw.visitMaxs(1, 1);
        mw.visitEnd();
        Context context = new Context();
        ArrayList<PropertyInfo> getters = new ArrayList<PropertyInfo>();
        this.computeGetters(clazz, aliasMap, getters);
        mw = cw.visitMethod(1, "write", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;)V", null, new String[]{"java/io/IOException"});
        mw.visitVarInsn(25, context.serializer());
        mw.visitMethodInsn(182, JSONASMUtil.getType(JSONSerializer.class), "getWriter", "()" + JSONASMUtil.getDesc(SerializeWriter.class));
        mw.visitVarInsn(58, context.var("out"));
        Label _else = new Label();
        mw.visitVarInsn(25, context.var("out"));
        mw.visitFieldInsn(178, JSONASMUtil.getType(SerializerFeature.class), "SortField", "L" + JSONASMUtil.getType(SerializerFeature.class) + ";");
        mw.visitMethodInsn(182, JSONASMUtil.getType(SerializeWriter.class), "isEnabled", "(L" + JSONASMUtil.getType(SerializerFeature.class) + ";" + ")Z");
        mw.visitJumpInsn(153, _else);
        mw.visitVarInsn(25, 0);
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, 2);
        mw.visitMethodInsn(182, className, "write1", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;)V");
        mw.visitInsn(177);
        mw.visitLabel(_else);
        mw.visitVarInsn(25, context.obj());
        mw.visitTypeInsn(192, JSONASMUtil.getType(clazz));
        mw.visitVarInsn(58, context.var("entity"));
        this.generateWriteMethod(clazz, mw, getters, context);
        mw.visitInsn(177);
        mw.visitMaxs(5, context.getVariantCount() + 1);
        mw.visitEnd();
        context = new Context();
        getters = new ArrayList();
        this.computeGetters(clazz, aliasMap, getters);
        Collections.sort(getters);
        mw = cw.visitMethod(1, "write1", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;)V", null, new String[]{"java/io/IOException"});
        mw.visitVarInsn(25, context.serializer());
        mw.visitMethodInsn(182, JSONASMUtil.getType(JSONSerializer.class), "getWriter", "()" + JSONASMUtil.getDesc(SerializeWriter.class));
        mw.visitVarInsn(58, context.var("out"));
        mw.visitVarInsn(25, context.obj());
        mw.visitTypeInsn(192, JSONASMUtil.getType(clazz));
        mw.visitVarInsn(58, context.var("entity"));
        this.generateWriteMethod(clazz, mw, getters, context);
        mw.visitInsn(177);
        mw.visitMaxs(5, context.getVariantCount() + 1);
        mw.visitEnd();
        byte[] code = cw.toByteArray();
        Class<?> exampleClass = this.classLoader.defineClassF(className, code, 0, code.length);
        Object instance = exampleClass.newInstance();
        return (ObjectSerializer)instance;
    }

    private void generateWriteMethod(Class<?> clazz, MethodVisitor mw, List<PropertyInfo> getters, Context context) throws Exception {
        Label end = new Label();
        int size = getters.size();
        if (size == 0) {
            mw.visitVarInsn(25, context.var("out"));
            mw.visitLdcInsn("{}");
            mw.visitMethodInsn(182, JSONASMUtil.getType(SerializeWriter.class), "write", "(Ljava/lang/String;)V");
            return;
        }
        mw.visitVarInsn(16, 123);
        mw.visitVarInsn(54, context.var("seperator"));
        for (int i = 0; i < size; ++i) {
            PropertyInfo property = getters.get(i);
            Method method = property.getMethod();
            Class<?> propertyClass = method.getReturnType();
            mw.visitLdcInsn(property.getName());
            mw.visitVarInsn(58, context.fieldName());
            if (propertyClass == Byte.TYPE) {
                this._byte(clazz, mw, property, context);
                continue;
            }
            if (propertyClass == Short.TYPE) {
                this._short(clazz, mw, property, context);
                continue;
            }
            if (propertyClass == Integer.TYPE) {
                this._int(clazz, mw, property, context);
                continue;
            }
            if (propertyClass == Long.TYPE) {
                this._long(clazz, mw, property, context);
                continue;
            }
            if (propertyClass == Float.TYPE) {
                this._float(clazz, mw, property, context);
                continue;
            }
            if (propertyClass == Double.TYPE) {
                this._double(clazz, mw, property, context);
                continue;
            }
            if (propertyClass == Boolean.TYPE) {
                this._boolean(clazz, mw, property, context);
                continue;
            }
            if (propertyClass == Character.TYPE) {
                this._char(clazz, mw, property, context);
                continue;
            }
            if (propertyClass == String.class) {
                this._string(clazz, mw, property, context);
                continue;
            }
            if (propertyClass == BigDecimal.class) {
                this._decimal(clazz, mw, property, context);
                continue;
            }
            if (propertyClass == List.class) {
                this._list(clazz, mw, property, context);
                continue;
            }
            if (propertyClass.isEnum()) {
                this._enum(clazz, mw, property, context);
                continue;
            }
            this._object(clazz, mw, property, context);
        }
        Label _if = new Label();
        Label _else = new Label();
        Label _end_if = new Label();
        mw.visitLabel(_if);
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitIntInsn(16, 123);
        mw.visitJumpInsn(160, _else);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitLdcInsn("{}");
        mw.visitMethodInsn(182, JSONASMUtil.getType(SerializeWriter.class), "write", "(Ljava/lang/String;)V");
        mw.visitJumpInsn(167, _end_if);
        mw.visitLabel(_else);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(16, 125);
        mw.visitMethodInsn(182, JSONASMUtil.getType(SerializeWriter.class), "write", "(C)V");
        mw.visitLabel(_end_if);
        mw.visitLabel(end);
    }

    private void _object(Class<?> clazz, MethodVisitor mw, PropertyInfo property, Context context) {
        Method method = property.getMethod();
        Class<?> propertyClass = method.getReturnType();
        Label _end = new Label();
        mw.visitVarInsn(25, context.var("entity"));
        mw.visitMethodInsn(182, JSONASMUtil.getType(clazz), method.getName(), "()" + JSONASMUtil.getDesc(propertyClass));
        mw.visitVarInsn(58, context.var("object"));
        this._filters(mw, property, context, _end);
        this._writeObject(mw, property, context, _end);
        mw.visitLabel(_end);
    }

    private void _enum(Class<?> clazz, MethodVisitor mw, PropertyInfo property, Context context) {
        Method method = property.getMethod();
        Class<?> propertyClass = method.getReturnType();
        Label _not_null = new Label();
        Label _end_if = new Label();
        Label _end = new Label();
        mw.visitVarInsn(25, context.var("entity"));
        mw.visitMethodInsn(182, JSONASMUtil.getType(clazz), method.getName(), "()L" + JSONASMUtil.getType(propertyClass) + ";");
        mw.visitTypeInsn(192, JSONASMUtil.getType(Enum.class));
        mw.visitVarInsn(58, context.var("enum"));
        this._filters(mw, property, context, _end);
        mw.visitVarInsn(25, context.var("enum"));
        mw.visitJumpInsn(199, _not_null);
        this._if_write_null(mw, property, context);
        mw.visitJumpInsn(167, _end_if);
        mw.visitLabel(_not_null);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitVarInsn(25, context.fieldName());
        mw.visitVarInsn(25, context.var("enum"));
        mw.visitMethodInsn(182, JSONASMUtil.getType(SerializeWriter.class), "writeFieldValue", "(CLjava/lang/String;L" + JSONASMUtil.getType(Enum.class) + ";)V");
        mw.visitLabel(_end_if);
        this._seperator(mw, context);
        mw.visitLabel(_end);
    }

    private void _long(Class<?> clazz, MethodVisitor mw, PropertyInfo property, Context context) {
        Method method = property.getMethod();
        Label _end = new Label();
        mw.visitVarInsn(25, context.var("entity"));
        mw.visitMethodInsn(182, JSONASMUtil.getType(clazz), method.getName(), "()J");
        mw.visitVarInsn(55, context.var("long", 2));
        this._filters(mw, property, context, _end);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitVarInsn(25, context.fieldName());
        mw.visitVarInsn(22, context.var("long"));
        mw.visitMethodInsn(182, JSONASMUtil.getType(SerializeWriter.class), "writeFieldValue", "(CLjava/lang/String;J)V");
        this._seperator(mw, context);
        mw.visitLabel(_end);
    }

    private void _float(Class<?> clazz, MethodVisitor mw, PropertyInfo property, Context context) {
        Method method = property.getMethod();
        Label _end = new Label();
        mw.visitVarInsn(25, context.var("entity"));
        mw.visitMethodInsn(182, JSONASMUtil.getType(clazz), method.getName(), "()F");
        mw.visitVarInsn(56, context.var("float"));
        this._filters(mw, property, context, _end);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitVarInsn(25, context.fieldName());
        mw.visitVarInsn(23, context.var("float"));
        mw.visitMethodInsn(182, JSONASMUtil.getType(SerializeWriter.class), "writeFieldValue", "(CLjava/lang/String;F)V");
        this._seperator(mw, context);
        mw.visitLabel(_end);
    }

    private void _double(Class<?> clazz, MethodVisitor mw, PropertyInfo property, Context context) {
        Method method = property.getMethod();
        Label _end = new Label();
        mw.visitVarInsn(25, context.var("entity"));
        mw.visitMethodInsn(182, JSONASMUtil.getType(clazz), method.getName(), "()D");
        mw.visitVarInsn(57, context.var("double"));
        this._filters(mw, property, context, _end);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitVarInsn(25, context.fieldName());
        mw.visitVarInsn(24, context.var("double"));
        mw.visitMethodInsn(182, JSONASMUtil.getType(SerializeWriter.class), "writeFieldValue", "(CLjava/lang/String;D)V");
        this._seperator(mw, context);
        mw.visitLabel(_end);
    }

    private void _char(Class<?> clazz, MethodVisitor mw, PropertyInfo property, Context context) {
        Method method = property.getMethod();
        Label _end = new Label();
        mw.visitVarInsn(25, context.var("entity"));
        mw.visitMethodInsn(182, JSONASMUtil.getType(clazz), method.getName(), "()C");
        mw.visitVarInsn(54, context.var("char"));
        this._filters(mw, property, context, _end);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitVarInsn(25, context.fieldName());
        mw.visitVarInsn(21, context.var("char"));
        mw.visitMethodInsn(182, JSONASMUtil.getType(SerializeWriter.class), "writeFieldValue", "(CLjava/lang/String;C)V");
        this._seperator(mw, context);
        mw.visitLabel(_end);
    }

    private void _boolean(Class<?> clazz, MethodVisitor mw, PropertyInfo property, Context context) {
        Method method = property.getMethod();
        Label _end = new Label();
        mw.visitVarInsn(25, context.var("entity"));
        mw.visitMethodInsn(182, JSONASMUtil.getType(clazz), method.getName(), "()Z");
        mw.visitVarInsn(54, context.var("boolean"));
        this._filters(mw, property, context, _end);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitVarInsn(25, context.fieldName());
        mw.visitVarInsn(21, context.var("boolean"));
        mw.visitMethodInsn(182, JSONASMUtil.getType(SerializeWriter.class), "writeFieldValue", "(CLjava/lang/String;Z)V");
        this._seperator(mw, context);
        mw.visitLabel(_end);
    }

    private void _byte(Class<?> clazz, MethodVisitor mw, PropertyInfo property, Context context) {
        Method method = property.getMethod();
        Label _end = new Label();
        mw.visitVarInsn(25, context.var("entity"));
        mw.visitMethodInsn(182, JSONASMUtil.getType(clazz), method.getName(), "()B");
        mw.visitVarInsn(54, context.var("byte"));
        this._filters(mw, property, context, _end);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitVarInsn(25, context.fieldName());
        mw.visitVarInsn(21, context.var("byte"));
        mw.visitMethodInsn(182, JSONASMUtil.getType(SerializeWriter.class), "writeFieldValue", "(CLjava/lang/String;I)V");
        this._seperator(mw, context);
        mw.visitLabel(_end);
    }

    private void _short(Class<?> clazz, MethodVisitor mw, PropertyInfo property, Context context) {
        Method method = property.getMethod();
        Label _end = new Label();
        mw.visitVarInsn(25, context.var("entity"));
        mw.visitMethodInsn(182, JSONASMUtil.getType(clazz), method.getName(), "()S");
        mw.visitVarInsn(54, context.var("short"));
        this._filters(mw, property, context, _end);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitVarInsn(25, context.fieldName());
        mw.visitVarInsn(21, context.var("short"));
        mw.visitMethodInsn(182, JSONASMUtil.getType(SerializeWriter.class), "writeFieldValue", "(CLjava/lang/String;I)V");
        this._seperator(mw, context);
        mw.visitLabel(_end);
    }

    private void _int(Class<?> clazz, MethodVisitor mw, PropertyInfo property, Context context) {
        Method method = property.getMethod();
        Label _end = new Label();
        mw.visitVarInsn(25, context.var("entity"));
        mw.visitMethodInsn(182, JSONASMUtil.getType(clazz), method.getName(), "()I");
        mw.visitVarInsn(54, context.var("int"));
        this._filters(mw, property, context, _end);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitVarInsn(25, context.fieldName());
        mw.visitVarInsn(21, context.var("int"));
        mw.visitMethodInsn(182, JSONASMUtil.getType(SerializeWriter.class), "writeFieldValue", "(CLjava/lang/String;I)V");
        this._seperator(mw, context);
        mw.visitLabel(_end);
    }

    private void _decimal(Class<?> clazz, MethodVisitor mw, PropertyInfo property, Context context) {
        Method method = property.getMethod();
        Label _end = new Label();
        mw.visitVarInsn(25, context.var("entity"));
        mw.visitMethodInsn(182, JSONASMUtil.getType(clazz), method.getName(), "()Ljava/math/BigDecimal;");
        mw.visitVarInsn(58, context.var("decimal"));
        this._filters(mw, property, context, _end);
        Label _if = new Label();
        Label _else = new Label();
        Label _end_if = new Label();
        mw.visitLabel(_if);
        mw.visitVarInsn(25, context.var("decimal"));
        mw.visitJumpInsn(199, _else);
        this._if_write_null(mw, property, context);
        mw.visitJumpInsn(167, _end_if);
        mw.visitLabel(_else);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitVarInsn(25, context.fieldName());
        mw.visitVarInsn(25, context.var("decimal"));
        mw.visitMethodInsn(182, JSONASMUtil.getType(SerializeWriter.class), "writeFieldValue", "(CLjava/lang/String;Ljava/math/BigDecimal;)V");
        this._seperator(mw, context);
        mw.visitJumpInsn(167, _end_if);
        mw.visitLabel(_end_if);
        mw.visitLabel(_end);
    }

    private void _string(Class<?> clazz, MethodVisitor mw, PropertyInfo property, Context context) {
        Method method = property.getMethod();
        Label _end = new Label();
        mw.visitVarInsn(25, context.var("entity"));
        mw.visitMethodInsn(182, JSONASMUtil.getType(clazz), method.getName(), "()Ljava/lang/String;");
        mw.visitVarInsn(58, context.var("string"));
        this._filters(mw, property, context, _end);
        Label _else = new Label();
        Label _end_if = new Label();
        mw.visitVarInsn(25, context.var("string"));
        mw.visitJumpInsn(199, _else);
        this._if_write_null(mw, property, context);
        mw.visitJumpInsn(167, _end_if);
        mw.visitLabel(_else);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitVarInsn(25, context.fieldName());
        mw.visitVarInsn(25, context.var("string"));
        mw.visitMethodInsn(182, JSONASMUtil.getType(SerializeWriter.class), "writeFieldValue", "(CLjava/lang/String;Ljava/lang/String;)V");
        this._seperator(mw, context);
        mw.visitLabel(_end_if);
        mw.visitLabel(_end);
    }

    private void _list(Class<?> clazz, MethodVisitor mw, PropertyInfo property, Context context) {
        Method method = property.getMethod();
        Class<?> propertyClass = method.getReturnType();
        Type propertyType = method.getGenericReturnType();
        Object elementType = Object.class;
        if (propertyType instanceof ParameterizedType) {
            elementType = ((ParameterizedType)propertyType).getActualTypeArguments()[0];
        }
        Label _end = new Label();
        Label _if = new Label();
        Label _else = new Label();
        Label _end_if = new Label();
        mw.visitLabel(_if);
        mw.visitVarInsn(25, context.var("entity"));
        mw.visitMethodInsn(182, JSONASMUtil.getType(clazz), method.getName(), "()L" + JSONASMUtil.getType(propertyClass) + ";");
        mw.visitTypeInsn(192, JSONASMUtil.getType(List.class));
        mw.visitVarInsn(58, context.var("list"));
        this._filters(mw, property, context, _end);
        mw.visitVarInsn(25, context.var("list"));
        mw.visitJumpInsn(199, _else);
        this._if_write_null(mw, property, context);
        mw.visitJumpInsn(167, _end_if);
        mw.visitLabel(_else);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitMethodInsn(182, JSONASMUtil.getType(SerializeWriter.class), "write", "(C)V");
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(25, context.fieldName());
        mw.visitMethodInsn(182, JSONASMUtil.getType(SerializeWriter.class), "writeFieldName", "(Ljava/lang/String;)V");
        mw.visitVarInsn(25, context.var("list"));
        mw.visitMethodInsn(185, JSONASMUtil.getType(List.class), "size", "()I");
        mw.visitVarInsn(54, context.var("int"));
        Label _if_3 = new Label();
        Label _else_3 = new Label();
        Label _end_if_3 = new Label();
        mw.visitLabel(_if_3);
        mw.visitVarInsn(21, context.var("int"));
        mw.visitInsn(3);
        mw.visitJumpInsn(160, _else_3);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitLdcInsn("[]");
        mw.visitMethodInsn(182, JSONASMUtil.getType(SerializeWriter.class), "write", "(Ljava/lang/String;)V");
        mw.visitJumpInsn(167, _end_if_3);
        mw.visitLabel(_else_3);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(16, 91);
        mw.visitMethodInsn(182, JSONASMUtil.getType(SerializeWriter.class), "write", "(C)V");
        mw.visitInsn(1);
        mw.visitTypeInsn(192, JSONASMUtil.getType(ObjectSerializer.class));
        mw.visitVarInsn(58, context.var("list_ser"));
        Label _for = new Label();
        Label _end_for = new Label();
        mw.visitInsn(3);
        mw.visitVarInsn(54, context.var("i"));
        mw.visitLabel(_for);
        mw.visitVarInsn(21, context.var("i"));
        mw.visitVarInsn(21, context.var("int"));
        mw.visitInsn(4);
        mw.visitInsn(100);
        mw.visitJumpInsn(162, _end_for);
        if (elementType == String.class) {
            mw.visitVarInsn(25, context.var("out"));
            mw.visitVarInsn(25, context.var("list"));
            mw.visitVarInsn(21, context.var("i"));
            mw.visitMethodInsn(185, JSONASMUtil.getType(List.class), "get", "(I)Ljava/lang/Object;");
            mw.visitTypeInsn(192, JSONASMUtil.getType(String.class));
            mw.visitVarInsn(16, 44);
            mw.visitMethodInsn(182, JSONASMUtil.getType(SerializeWriter.class), "writeString", "(Ljava/lang/String;C)V");
        } else {
            mw.visitVarInsn(25, context.serializer());
            mw.visitVarInsn(25, context.var("list"));
            mw.visitVarInsn(21, context.var("i"));
            mw.visitMethodInsn(185, JSONASMUtil.getType(List.class), "get", "(I)Ljava/lang/Object;");
            mw.visitMethodInsn(182, JSONASMUtil.getType(JSONSerializer.class), "write", "(Ljava/lang/Object;)V");
            mw.visitVarInsn(25, context.var("out"));
            mw.visitVarInsn(16, 44);
            mw.visitMethodInsn(182, JSONASMUtil.getType(SerializeWriter.class), "write", "(C)V");
        }
        mw.visitIincInsn(context.var("i"), 1);
        mw.visitJumpInsn(167, _for);
        mw.visitLabel(_end_for);
        if (elementType == String.class) {
            mw.visitVarInsn(25, context.var("out"));
            mw.visitVarInsn(25, context.var("list"));
            mw.visitVarInsn(21, context.var("int"));
            mw.visitInsn(4);
            mw.visitInsn(100);
            mw.visitMethodInsn(185, JSONASMUtil.getType(List.class), "get", "(I)Ljava/lang/Object;");
            mw.visitTypeInsn(192, JSONASMUtil.getType(String.class));
            mw.visitVarInsn(16, 93);
            mw.visitMethodInsn(182, JSONASMUtil.getType(SerializeWriter.class), "writeString", "(Ljava/lang/String;C)V");
        } else {
            mw.visitVarInsn(25, context.serializer());
            mw.visitVarInsn(25, context.var("list"));
            mw.visitVarInsn(21, context.var("i"));
            mw.visitMethodInsn(185, JSONASMUtil.getType(List.class), "get", "(I)Ljava/lang/Object;");
            mw.visitMethodInsn(182, JSONASMUtil.getType(JSONSerializer.class), "write", "(Ljava/lang/Object;)V");
            mw.visitVarInsn(25, context.var("out"));
            mw.visitVarInsn(16, 93);
            mw.visitMethodInsn(182, JSONASMUtil.getType(SerializeWriter.class), "write", "(C)V");
        }
        mw.visitLabel(_end_if_3);
        this._seperator(mw, context);
        mw.visitLabel(_end_if);
        mw.visitLabel(_end);
    }

    private void _filters(MethodVisitor mw, PropertyInfo property, Context context, Label _end) {
        if (property.getField() != null && Modifier.isTransient(property.getField().getModifiers())) {
            mw.visitVarInsn(25, context.var("out"));
            mw.visitFieldInsn(178, JSONASMUtil.getType(SerializerFeature.class), "SkipTransientField", "L" + JSONASMUtil.getType(SerializerFeature.class) + ";");
            mw.visitMethodInsn(182, JSONASMUtil.getType(SerializeWriter.class), "isEnabled", "(L" + JSONASMUtil.getType(SerializerFeature.class) + ";" + ")Z");
            mw.visitJumpInsn(154, _end);
        }
        this._apply(mw, property, context);
        mw.visitJumpInsn(153, _end);
        this._processKey(mw, property, context);
        Label _else_processKey = new Label();
        this._processValue(mw, property, context);
        mw.visitVarInsn(25, context.original());
        mw.visitVarInsn(25, context.processValue());
        mw.visitJumpInsn(165, _else_processKey);
        this._writeObject(mw, property, context, _end);
        mw.visitJumpInsn(167, _end);
        mw.visitLabel(_else_processKey);
    }

    private void _writeObject(MethodVisitor mw, PropertyInfo property, Context context, Label _end) {
        Label _not_null = new Label();
        mw.visitVarInsn(25, context.processValue());
        mw.visitJumpInsn(199, _not_null);
        this._if_write_null(mw, property, context);
        mw.visitJumpInsn(167, _end);
        mw.visitLabel(_not_null);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitMethodInsn(182, JSONASMUtil.getType(SerializeWriter.class), "write", "(C)V");
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(25, context.fieldName());
        mw.visitMethodInsn(182, JSONASMUtil.getType(SerializeWriter.class), "writeFieldName", "(Ljava/lang/String;)V");
        mw.visitVarInsn(25, context.serializer());
        mw.visitVarInsn(25, context.processValue());
        mw.visitMethodInsn(182, JSONASMUtil.getType(JSONSerializer.class), "write", "(Ljava/lang/Object;)V");
        this._seperator(mw, context);
    }

    private void _apply(MethodVisitor mw, PropertyInfo property, Context context) {
        Method method = property.getMethod();
        Class<?> propertyClass = method.getReturnType();
        mw.visitVarInsn(25, context.serializer());
        mw.visitVarInsn(25, context.obj());
        mw.visitVarInsn(25, context.fieldName());
        if (propertyClass == Byte.TYPE) {
            mw.visitVarInsn(21, context.var("byte"));
            mw.visitMethodInsn(184, JSONASMUtil.getType(FilterUtils.class), "apply", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;B)Z");
        } else if (propertyClass == Short.TYPE) {
            mw.visitVarInsn(21, context.var("short"));
            mw.visitMethodInsn(184, JSONASMUtil.getType(FilterUtils.class), "apply", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;S)Z");
        } else if (propertyClass == Integer.TYPE) {
            mw.visitVarInsn(21, context.var("int"));
            mw.visitMethodInsn(184, JSONASMUtil.getType(FilterUtils.class), "apply", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;I)Z");
        } else if (propertyClass == Character.TYPE) {
            mw.visitVarInsn(21, context.var("char"));
            mw.visitMethodInsn(184, JSONASMUtil.getType(FilterUtils.class), "apply", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;C)Z");
        } else if (propertyClass == Long.TYPE) {
            mw.visitVarInsn(22, context.var("long"));
            mw.visitMethodInsn(184, JSONASMUtil.getType(FilterUtils.class), "apply", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;J)Z");
        } else if (propertyClass == Float.TYPE) {
            mw.visitVarInsn(23, context.var("float"));
            mw.visitMethodInsn(184, JSONASMUtil.getType(FilterUtils.class), "apply", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;F)Z");
        } else if (propertyClass == Double.TYPE) {
            mw.visitVarInsn(24, context.var("double"));
            mw.visitMethodInsn(184, JSONASMUtil.getType(FilterUtils.class), "apply", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;D)Z");
        } else if (propertyClass == Boolean.TYPE) {
            mw.visitVarInsn(21, context.var("boolean"));
            mw.visitMethodInsn(184, JSONASMUtil.getType(FilterUtils.class), "apply", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;B)Z");
        } else if (propertyClass == BigDecimal.class) {
            mw.visitVarInsn(25, context.var("decimal"));
            mw.visitMethodInsn(184, JSONASMUtil.getType(FilterUtils.class), "apply", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)Z");
        } else if (propertyClass == String.class) {
            mw.visitVarInsn(25, context.var("string"));
            mw.visitMethodInsn(184, JSONASMUtil.getType(FilterUtils.class), "apply", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)Z");
        } else if (propertyClass.isEnum()) {
            mw.visitVarInsn(25, context.var("enum"));
            mw.visitMethodInsn(184, JSONASMUtil.getType(FilterUtils.class), "apply", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)Z");
        } else if (propertyClass == List.class) {
            mw.visitVarInsn(25, context.var("list"));
            mw.visitMethodInsn(184, JSONASMUtil.getType(FilterUtils.class), "apply", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)Z");
        } else {
            mw.visitVarInsn(25, context.var("object"));
            mw.visitMethodInsn(184, JSONASMUtil.getType(FilterUtils.class), "apply", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)Z");
        }
    }

    private void _processValue(MethodVisitor mw, PropertyInfo property, Context context) {
        Method method = property.getMethod();
        Class<?> propertyClass = method.getReturnType();
        mw.visitVarInsn(25, context.serializer());
        mw.visitVarInsn(25, context.obj());
        mw.visitVarInsn(25, context.fieldName());
        if (propertyClass == Byte.TYPE) {
            mw.visitVarInsn(21, context.var("byte"));
            mw.visitMethodInsn(184, JSONASMUtil.getType(Byte.class), "valueOf", "(B)Ljava/lang/Byte;");
        } else if (propertyClass == Short.TYPE) {
            mw.visitVarInsn(21, context.var("short"));
            mw.visitMethodInsn(184, JSONASMUtil.getType(Short.class), "valueOf", "(S)Ljava/lang/Short;");
        } else if (propertyClass == Integer.TYPE) {
            mw.visitVarInsn(21, context.var("int"));
            mw.visitMethodInsn(184, JSONASMUtil.getType(Integer.class), "valueOf", "(I)Ljava/lang/Integer;");
        } else if (propertyClass == Character.TYPE) {
            mw.visitVarInsn(21, context.var("char"));
            mw.visitMethodInsn(184, JSONASMUtil.getType(Character.class), "valueOf", "(C)Ljava/lang/Character;");
        } else if (propertyClass == Long.TYPE) {
            mw.visitVarInsn(22, context.var("long"));
            mw.visitMethodInsn(184, JSONASMUtil.getType(Long.class), "valueOf", "(J)Ljava/lang/Long;");
        } else if (propertyClass == Float.TYPE) {
            mw.visitVarInsn(23, context.var("float"));
            mw.visitMethodInsn(184, JSONASMUtil.getType(Float.class), "valueOf", "(F)Ljava/lang/Float;");
        } else if (propertyClass == Double.TYPE) {
            mw.visitVarInsn(24, context.var("double"));
            mw.visitMethodInsn(184, JSONASMUtil.getType(Double.class), "valueOf", "(D)Ljava/lang/Double;");
        } else if (propertyClass == Boolean.TYPE) {
            mw.visitVarInsn(21, context.var("boolean"));
            mw.visitMethodInsn(184, JSONASMUtil.getType(Boolean.class), "valueOf", "(Z)Ljava/lang/Boolean;");
        } else if (propertyClass == BigDecimal.class) {
            mw.visitVarInsn(25, context.var("decimal"));
        } else if (propertyClass == String.class) {
            mw.visitVarInsn(25, context.var("string"));
        } else if (propertyClass.isEnum()) {
            mw.visitVarInsn(25, context.var("enum"));
        } else if (propertyClass == List.class) {
            mw.visitVarInsn(25, context.var("list"));
        } else {
            mw.visitVarInsn(25, context.var("object"));
        }
        mw.visitVarInsn(58, context.original());
        mw.visitVarInsn(25, context.original());
        mw.visitMethodInsn(184, JSONASMUtil.getType(FilterUtils.class), "processValue", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;");
        mw.visitVarInsn(58, context.processValue());
    }

    private void _processKey(MethodVisitor mw, PropertyInfo property, Context context) {
        Method method = property.getMethod();
        Class<?> propertyClass = method.getReturnType();
        mw.visitVarInsn(25, context.serializer());
        mw.visitVarInsn(25, context.obj());
        mw.visitVarInsn(25, context.fieldName());
        if (propertyClass == Byte.TYPE) {
            mw.visitVarInsn(21, context.var("byte"));
            mw.visitMethodInsn(184, JSONASMUtil.getType(FilterUtils.class), "processKey", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;B)Ljava/lang/String;");
        } else if (propertyClass == Short.TYPE) {
            mw.visitVarInsn(21, context.var("short"));
            mw.visitMethodInsn(184, JSONASMUtil.getType(FilterUtils.class), "processKey", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;S)Ljava/lang/String;");
        } else if (propertyClass == Integer.TYPE) {
            mw.visitVarInsn(21, context.var("int"));
            mw.visitMethodInsn(184, JSONASMUtil.getType(FilterUtils.class), "processKey", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;I)Ljava/lang/String;");
        } else if (propertyClass == Character.TYPE) {
            mw.visitVarInsn(21, context.var("char"));
            mw.visitMethodInsn(184, JSONASMUtil.getType(FilterUtils.class), "processKey", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;C)Ljava/lang/String;");
        } else if (propertyClass == Long.TYPE) {
            mw.visitVarInsn(22, context.var("long"));
            mw.visitMethodInsn(184, JSONASMUtil.getType(FilterUtils.class), "processKey", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;J)Ljava/lang/String;");
        } else if (propertyClass == Float.TYPE) {
            mw.visitVarInsn(23, context.var("float"));
            mw.visitMethodInsn(184, JSONASMUtil.getType(FilterUtils.class), "processKey", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;F)Ljava/lang/String;");
        } else if (propertyClass == Double.TYPE) {
            mw.visitVarInsn(24, context.var("double"));
            mw.visitMethodInsn(184, JSONASMUtil.getType(FilterUtils.class), "processKey", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;D)Ljava/lang/String;");
        } else if (propertyClass == Boolean.TYPE) {
            mw.visitVarInsn(21, context.var("boolean"));
            mw.visitMethodInsn(184, JSONASMUtil.getType(FilterUtils.class), "processKey", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;Z)Ljava/lang/String;");
        } else if (propertyClass == BigDecimal.class) {
            mw.visitVarInsn(25, context.var("decimal"));
            mw.visitMethodInsn(184, JSONASMUtil.getType(FilterUtils.class), "processKey", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/String;");
        } else if (propertyClass == String.class) {
            mw.visitVarInsn(25, context.var("string"));
            mw.visitMethodInsn(184, JSONASMUtil.getType(FilterUtils.class), "processKey", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/String;");
        } else if (propertyClass.isEnum()) {
            mw.visitVarInsn(25, context.var("enum"));
            mw.visitMethodInsn(184, JSONASMUtil.getType(FilterUtils.class), "processKey", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/String;");
        } else if (propertyClass == List.class) {
            mw.visitVarInsn(25, context.var("list"));
            mw.visitMethodInsn(184, JSONASMUtil.getType(FilterUtils.class), "processKey", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/String;");
        } else {
            mw.visitVarInsn(25, context.var("object"));
            mw.visitMethodInsn(184, JSONASMUtil.getType(FilterUtils.class), "processKey", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/String;");
        }
        mw.visitVarInsn(58, context.fieldName());
    }

    private void _if_write_null(MethodVisitor mw, PropertyInfo property, Context context) {
        Method method = property.getMethod();
        Class<?> propertyClass = method.getReturnType();
        Label _if = new Label();
        Label _else = new Label();
        Label _write_null = new Label();
        Label _end_if = new Label();
        mw.visitLabel(_if);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitFieldInsn(178, JSONASMUtil.getType(SerializerFeature.class), "WriteMapNullValue", "L" + JSONASMUtil.getType(SerializerFeature.class) + ";");
        mw.visitMethodInsn(182, JSONASMUtil.getType(SerializeWriter.class), "isEnabled", "(L" + JSONASMUtil.getType(SerializerFeature.class) + ";" + ")Z");
        mw.visitJumpInsn(153, _else);
        mw.visitLabel(_write_null);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitVarInsn(25, context.fieldName());
        if (propertyClass == String.class || propertyClass == Character.class) {
            mw.visitMethodInsn(182, JSONASMUtil.getType(SerializeWriter.class), "writeFieldNullString", "(CLjava/lang/String;)V");
        } else if (Number.class.isAssignableFrom(propertyClass)) {
            mw.visitMethodInsn(182, JSONASMUtil.getType(SerializeWriter.class), "writeFieldNullNumber", "(CLjava/lang/String;)V");
        } else if (propertyClass == Boolean.class) {
            mw.visitMethodInsn(182, JSONASMUtil.getType(SerializeWriter.class), "writeFieldNullBoolean", "(CLjava/lang/String;)V");
        } else if (propertyClass == List.class || propertyClass.isArray()) {
            mw.visitMethodInsn(182, JSONASMUtil.getType(SerializeWriter.class), "writeFieldNullList", "(CLjava/lang/String;)V");
        } else {
            mw.visitMethodInsn(182, JSONASMUtil.getType(SerializeWriter.class), "writeFieldNull", "(CLjava/lang/String;)V");
        }
        this._seperator(mw, context);
        mw.visitJumpInsn(167, _end_if);
        mw.visitLabel(_else);
        mw.visitLabel(_end_if);
    }

    private void _seperator(MethodVisitor mw, Context context) {
        mw.visitVarInsn(16, 44);
        mw.visitVarInsn(54, context.var("seperator"));
    }

    private void computeGetters(Class<?> clazz, Map<String, String> aliasMap, List<PropertyInfo> getters) {
        for (Method method : clazz.getMethods()) {
            JSONField fieldAnnotation;
            Field field;
            String propertyName;
            String methodName = method.getName();
            if (Modifier.isStatic(method.getModifiers()) || method.getReturnType().equals(Void.TYPE) || method.getParameterTypes().length != 0) continue;
            JSONField annotation = method.getAnnotation(JSONField.class);
            if (annotation != null) {
                if (!annotation.serialize()) continue;
                if (annotation.name().length() != 0) {
                    propertyName = annotation.name();
                    if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) continue;
                    getters.add(new PropertyInfo(propertyName, method, null));
                    continue;
                }
            }
            if (methodName.startsWith("get")) {
                if (methodName.length() < 4 || methodName.equals("getClass") || !Character.isUpperCase(methodName.charAt(3))) continue;
                propertyName = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
                field = JavaBeanMapping.getField(clazz, propertyName);
                if (field != null && (fieldAnnotation = field.getAnnotation(JSONField.class)) != null && fieldAnnotation.name().length() != 0) {
                    propertyName = fieldAnnotation.name();
                    if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) continue;
                }
                if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) continue;
                getters.add(new PropertyInfo(propertyName, method, field));
            }
            if (!methodName.startsWith("is") || methodName.length() < 3 || !Character.isUpperCase(methodName.charAt(2))) continue;
            propertyName = Character.toLowerCase(methodName.charAt(2)) + methodName.substring(3);
            field = JavaBeanMapping.getField(clazz, propertyName);
            if (field != null && (fieldAnnotation = field.getAnnotation(JSONField.class)) != null && fieldAnnotation.name().length() != 0) {
                propertyName = fieldAnnotation.name();
                if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) continue;
            }
            if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) continue;
            getters.add(new PropertyInfo(propertyName, method, field));
        }
    }

    static class Context {
        private int variantIndex = 6;
        private Map<String, Integer> variants = new HashMap<String, Integer>();

        public int getThis() {
            return 0;
        }

        public int serializer() {
            return 1;
        }

        public int obj() {
            return 2;
        }

        public int fieldName() {
            return 3;
        }

        public int original() {
            return 4;
        }

        public int processValue() {
            return 5;
        }

        public int getVariantCount() {
            return this.variantIndex;
        }

        public int var(String name) {
            Integer i = this.variants.get(name);
            if (i == null) {
                this.variants.put(name, this.variantIndex++);
            }
            i = this.variants.get(name);
            return i;
        }

        public int var(String name, int increment) {
            Integer i = this.variants.get(name);
            if (i == null) {
                this.variants.put(name, this.variantIndex);
                this.variantIndex += increment;
            }
            i = this.variants.get(name);
            return i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ASMClassLoader
    extends ClassLoader {
        private final Map<String, Class<?>> classes = new HashMap();

        public ASMClassLoader() {
            super(ASMSerializerFactory.class.getClassLoader());
        }

        public Class<?> defineClassF(String name, byte[] b, int off, int len) throws ClassFormatError {
            Class<?> clazz = this.defineClass(name, b, off, len, null);
            if (clazz != null) {
                this.classes.put(name, clazz);
            }
            return clazz;
        }

        public boolean contains(String className) {
            return this.classes.containsKey(className);
        }

        public Map<String, Class<?>> getClasses() {
            return this.classes;
        }
    }
}

