/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;

public class CompositeDataSerializer
implements ObjectSerializer {
    public static final CompositeDataSerializer instance = new CompositeDataSerializer();

    public void write(JSONSerializer serializer, Object object) throws IOException {
        CompositeData data = (CompositeData)object;
        SerializeWriter out = serializer.getWriter();
        out.write('{');
        boolean first = true;
        CompositeType type = data.getCompositeType();
        for (String key : type.keySet()) {
            Object value = data.get(key);
            if (value == null && !serializer.isEnabled(SerializerFeature.WriteMapNullValue)) continue;
            if (!first) {
                out.write(',');
            }
            if (serializer.isEnabled(SerializerFeature.UseSingleQuotes)) {
                if (serializer.isEnabled(SerializerFeature.QuoteFieldNames)) {
                    out.writeKeyWithSingleQuote(key);
                } else {
                    out.writeKeyWithSingleQuoteIfHasSpecial(key);
                }
            } else if (serializer.isEnabled(SerializerFeature.QuoteFieldNames)) {
                out.writeKeyWithDoubleQuote(key);
            } else {
                out.writeKeyWithDoubleQuoteIfHasSpecial(key);
            }
            serializer.write(value);
            first = false;
        }
        out.write('}');
    }
}

