/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONASMUtil {
    public static String getType(Class<?> returnType) {
        if (returnType.isPrimitive()) {
            throw new IllegalArgumentException();
        }
        return JSONASMUtil.getAsmTypeAsString(returnType, false);
    }

    public static String getDesc(Class<?> returnType) {
        if (returnType.isPrimitive()) {
            return JSONASMUtil.getPrimitiveLetter(returnType);
        }
        if (returnType.isArray()) {
            return "[" + JSONASMUtil.getDesc(returnType.getComponentType());
        }
        return "L" + JSONASMUtil.getAsmTypeAsString(returnType, false) + ";";
    }

    public static String getAsmTypeAsString(Class<?> parameterType, boolean wrap) {
        if (parameterType.isArray()) {
            if (parameterType.getComponentType().isPrimitive()) {
                Class<?> componentType = parameterType.getComponentType();
                return "[" + JSONASMUtil.getPrimitiveLetter(componentType);
            }
            return "[" + JSONASMUtil.getAsmTypeAsString(parameterType.getComponentType(), true);
        }
        if (!parameterType.isPrimitive()) {
            String clsName = parameterType.getCanonicalName();
            if (parameterType.isMemberClass()) {
                int lastDot = clsName.lastIndexOf(".");
                clsName = clsName.substring(0, lastDot) + "$" + clsName.substring(lastDot + 1);
            }
            if (wrap) {
                return "L" + clsName.replaceAll("\\.", "/") + ";";
            }
            return clsName.replaceAll("\\.", "/");
        }
        return JSONASMUtil.getPrimitiveLetter(parameterType);
    }

    public static String getPrimitiveLetter(Class<?> type) {
        if (Integer.TYPE.equals(type)) {
            return "I";
        }
        if (Void.TYPE.equals(type)) {
            return "V";
        }
        if (Boolean.TYPE.equals(type)) {
            return "Z";
        }
        if (Character.TYPE.equals(type)) {
            return "C";
        }
        if (Byte.TYPE.equals(type)) {
            return "B";
        }
        if (Short.TYPE.equals(type)) {
            return "S";
        }
        if (Float.TYPE.equals(type)) {
            return "F";
        }
        if (Long.TYPE.equals(type)) {
            return "J";
        }
        if (Double.TYPE.equals(type)) {
            return "D";
        }
        throw new IllegalStateException("Type: " + type.getCanonicalName() + " is not a primitive type");
    }
}

