/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.visitor;

import com.alibaba.fastjson.JSONAware;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONStreamAware;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.visitor.JSONOutputVisitor;
import com.alibaba.fastjson.visitor.JSONVisitorAdapter;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJSONOutputVisitor
extends JSONVisitorAdapter
implements JSONOutputVisitor {
    protected final SerializeWriter out;
    protected boolean ignoreNull = true;

    public DefaultJSONOutputVisitor(SerializeWriter out) {
        this.out = out;
    }

    @Override
    public boolean isIgnoreNull() {
        return this.ignoreNull;
    }

    @Override
    public void setIgnoreNull(boolean ignoreNull) {
        this.ignoreNull = ignoreNull;
    }

    @Override
    public Appendable getOut() {
        return this.out;
    }

    @Override
    public boolean visitArray(Collection<?> array) {
        this.print('[');
        boolean first = true;
        for (Object item : array) {
            if (!first) {
                this.print(',');
            }
            this.accept(item);
            first = false;
        }
        this.print(']');
        return false;
    }

    @Override
    public boolean visitArray(Object[] array) {
        this.print('[');
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                this.print(',');
            }
            this.accept(array[i]);
        }
        this.print(']');
        return false;
    }

    @Override
    public boolean visitObject(Map<?, ?> map) {
        this.print('{');
        boolean first = true;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (this.ignoreNull && entry.getValue() == null) continue;
            if (!first) {
                this.print(',');
            }
            this.acceptEntry(entry);
            first = false;
        }
        this.print('}');
        return false;
    }

    @Override
    public void visitKey(String key) {
        this.print(key);
    }

    @Override
    public boolean visitEntry(Map.Entry<?, ?> entry) {
        this.acceptKey(entry.getKey().toString());
        this.print(':');
        this.accept(entry.getValue());
        return false;
    }

    @Override
    public void visitValue(String value) {
        this.print(value);
    }

    @Override
    public void visitValue(Date value) {
        this.print0("new Date(");
        this.print0(Long.toString(value.getTime()));
        this.print(')');
    }

    @Override
    public void visitValue(Number value) {
        if (value.equals(Double.NaN) || value.equals(Float.valueOf(Float.NaN))) {
            this.print0("null");
            return;
        }
        this.print0(value.toString());
    }

    @Override
    public void visitValue(boolean value) {
        this.print0(value ? "true" : "false");
    }

    @Override
    public void visitNull() {
        this.print0("null");
    }

    protected void print0(String text) {
        this.out.append(text);
    }

    @Override
    public void print(String text) {
        this.out.writeString(text);
    }

    @Override
    public void print(char ch) {
        this.out.append(ch);
    }

    @Override
    public void visitValue(char value) {
        this.print(new String(Character.toString(value)));
    }

    @Override
    public void visitBean(JSONStreamAware object) {
        if (object == null) {
            this.print0("null");
            return;
        }
        try {
            object.writeJSONString(this.out);
        }
        catch (IOException e) {
            throw new JSONException("visitBean error", e);
        }
    }

    @Override
    public void visitBean(JSONAware object) {
        if (object == null) {
            this.print0("null");
            return;
        }
        this.print(object.toJSONString());
    }

    @Override
    public void visitBean(Object javaBean) {
        if (this.javaBeanHandler == null) {
            throw new UnsupportedOperationException();
        }
        this.javaBeanHandler.handle(javaBean, this);
    }

    @Override
    public void println() {
    }

    @Override
    public void incrementIndent() {
    }

    @Override
    public void decementIndent() {
    }
}

