/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.visitor;

import com.alibaba.fastjson.JSONAware;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONStreamAware;
import com.alibaba.fastjson.visitor.JSONVisitor;
import com.alibaba.fastjson.visitor.JavaBeanHandler;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONVisitorAdapter
implements JSONVisitor {
    protected JavaBeanHandler javaBeanHandler;
    protected int depth = 0;
    private int maxDepth = 100;

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    @Override
    public JavaBeanHandler getJavaBeanHandler() {
        return this.javaBeanHandler;
    }

    @Override
    public void setJavaBeanHandler(JavaBeanHandler javaBeanHandler) {
        this.javaBeanHandler = javaBeanHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(Object object) {
        if (object == null) {
            this.acceptNull();
            return;
        }
        Class<?> clazz = object.getClass();
        ++this.depth;
        try {
            if (this.depth > this.maxDepth) {
                throw new JSONException("depth " + this.depth + ", maybe circular references");
            }
            if (clazz == Integer.class) {
                this.acceptValue((Number)object);
            } else if (clazz == Long.class) {
                this.acceptValue((Number)object);
            } else if (object instanceof Map) {
                this.acceptObject((Map)object);
            } else if (object instanceof Collection) {
                this.acceptArray((Collection)object);
            } else if (object instanceof Map.Entry) {
                this.acceptEntry((Map.Entry)object);
            } else if (object instanceof Boolean) {
                this.acceptValue((Boolean)object);
            } else if (object instanceof Number) {
                this.acceptValue((Number)object);
            } else if (object instanceof String) {
                this.acceptValue((String)object);
            } else if (object instanceof Date) {
                this.acceptValue((Date)object);
            } else if (object instanceof Character) {
                this.acceptValue((Character)object);
            } else if (object instanceof JSONAware) {
                this.acceptBean((JSONAware)object);
            } else if (object instanceof JSONStreamAware) {
                this.acceptBean((JSONStreamAware)object);
            } else if (object.getClass().isArray()) {
                this.acceptArray(object);
            } else {
                this.acceptBean(object);
            }
        }
        finally {
            --this.depth;
        }
    }

    @Override
    public void acceptBean(JSONAware javaBean) {
        this.preVisit(javaBean);
        this.visitBean(javaBean);
        this.endVisitBean(javaBean);
        this.postVisit(javaBean);
    }

    @Override
    public void acceptBean(JSONStreamAware javaBean) {
        this.preVisit(javaBean);
        this.visitBean(javaBean);
        this.endVisitBean(javaBean);
        this.postVisit(javaBean);
    }

    @Override
    public void acceptBean(Object javaBean) {
        this.preVisit(javaBean);
        this.visitBean(javaBean);
        this.endVisitBean(javaBean);
        this.postVisit(javaBean);
    }

    @Override
    public void acceptNull() {
        this.preVisit(null);
        this.visitNull();
        this.endVisitNull();
        this.postVisit(null);
    }

    @Override
    public void acceptValue(Date value) {
        this.preVisit(value);
        this.visitValue(value);
        this.endVisitValue(value);
        this.postVisit(value);
    }

    public void acceptValue(Character value) {
        this.preVisit(value);
        this.visitValue(value.charValue());
        this.endVisitValue(value.charValue());
        this.postVisit(value);
    }

    @Override
    public void acceptValue(Number value) {
        this.preVisit(value);
        this.visitValue(value);
        this.endVisitValue(value);
        this.postVisit(value);
    }

    @Override
    public void acceptValue(String value) {
        this.preVisit(value);
        this.visitValue(value);
        this.endVisitValue(value);
        this.postVisit(value);
    }

    @Override
    public void acceptValue(Boolean value) {
        this.preVisit(value);
        this.visitValue(value);
        this.endVisitValue(value);
        this.postVisit(value);
    }

    @Override
    public void acceptKey(String key) {
        this.preVisit(key);
        this.visitKey(key);
        this.endVisitKey(key);
        this.postVisit(key);
    }

    @Override
    public void acceptArray(Collection<?> array) {
        this.preVisit(array);
        if (this.visitArray(array)) {
            for (Object item : array) {
                this.accept(item);
            }
        }
        this.endVisitArray(array);
        this.postVisit(array);
    }

    public void acceptArray(Object array) {
        int length = Array.getLength(array);
        Object[] objArray = new Object[length];
        for (int i = 0; i < length; ++i) {
            objArray[i] = Array.get(array, i);
        }
        this.acceptArray(objArray);
    }

    public void acceptArray(Object[] array) {
        this.preVisit(array);
        if (this.visitArray(array)) {
            for (Object item : array) {
                this.accept(item);
            }
        }
        this.endVisitArray(array);
        this.postVisit(array);
    }

    @Override
    public void acceptObject(Map<?, ?> object) {
        this.preVisit(object);
        if (this.visitObject(object)) {
            for (Map.Entry<?, ?> entry : object.entrySet()) {
                this.acceptEntry(entry);
            }
        }
        this.endVisitObject(object);
        this.postVisit(object);
    }

    @Override
    public void acceptEntry(Map.Entry<?, ?> entry) {
        this.preVisit(entry);
        if (this.visitEntry(entry)) {
            this.acceptKey(entry.getKey().toString());
            this.accept(entry.getValue());
        }
        this.endVisitEntry(entry);
        this.postVisit(entry);
    }

    @Override
    public boolean visitObject(Map<?, ?> map) {
        return true;
    }

    @Override
    public void endVisitObject(Map<?, ?> map) {
    }

    @Override
    public boolean visitArray(Collection<?> array) {
        return true;
    }

    public boolean visitArray(Object[] array) {
        return true;
    }

    @Override
    public void endVisitArray(Collection<?> array) {
    }

    public void endVisitArray(Object[] array) {
    }

    @Override
    public void preVisit(Object value) {
    }

    @Override
    public void postVisit(Object value) {
    }

    @Override
    public boolean visitEntry(Map.Entry<?, ?> entry) {
        return true;
    }

    @Override
    public void endVisitEntry(Map.Entry<?, ?> entry) {
    }

    @Override
    public void visitValue(Number value) {
    }

    @Override
    public void endVisitValue(Number value) {
    }

    public void visitValue(char value) {
    }

    public void endVisitValue(char value) {
    }

    @Override
    public void visitValue(boolean value) {
    }

    @Override
    public void endVisitValue(boolean value) {
    }

    @Override
    public void visitValue(String value) {
    }

    @Override
    public void endVisitValue(String value) {
    }

    @Override
    public void visitKey(String key) {
    }

    @Override
    public void endVisitKey(String key) {
    }

    @Override
    public void visitNull() {
    }

    @Override
    public void endVisitNull() {
    }

    @Override
    public void visitBean(JSONStreamAware object) {
    }

    @Override
    public void endVisitBean(JSONStreamAware object) {
    }

    @Override
    public void visitBean(JSONAware object) {
    }

    @Override
    public void endVisitBean(JSONAware object) {
    }

    @Override
    public void visitValue(Date value) {
    }

    @Override
    public void endVisitValue(Date value) {
    }

    @Override
    public void visitBean(Object object) {
    }

    @Override
    public void endVisitBean(Object object) {
    }
}

