package com.shanpayapi.cn;

import java.io.IOException;
import java.io.UnsupportedEncodingException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.shanpayapi.cn.exception.PayException;
import com.shanpayapi.cn.util.Md5Util;
/**
 * 
 * Description：服务器异步通知页面 <br>
 * 
 * ClassName：ReturnUrl <br>
 * 
 * Date：2016年6月26日下午2:50:29 <br>
 * 
 * Version：v1.0 <br>
 * 
 */
public class NotifyUrl extends HttpServlet {

	/**
	*
	**/
	private static final long serialVersionUID = 1L;

	/**
	 * Constructor of the object.
	 */
	public NotifyUrl() {
		super();
	}

	/**
	 * Destruction of the servlet. <br>
	 */
	public void destroy() {
		super.destroy(); // Just puts "destroy" string in log
		// Put your code here
	}

	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {

		doPost(request, response);
	}
	
	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		boolean shanNotify = md5VerifyShan(request);
		String result = "success";
		if(shanNotify){
			if("TRADE_SUCCESS".equals(request.getParameter("trade_status"))){
				 /*
				加入您的入库及判断代码;
				判断返回金额与实金额是否想同;
				判断订单当前状态;
				完成以上才视为支付成功
				*/
				//商户订单号
				String out_trade_no = request.getParameter("out_order_no");
				//云通付交易号
				String trade_no =  request.getParameter("trade_no");
				//价格
				String price =  request.getParameter("total_fee");
			}
		}else {
			   //验证失败
			result =  "fail";//请不要修改或删除
		}
		request.setAttribute("result_info", result);
		request.getRequestDispatcher("notify_url.jsp").forward(request,response);
	}

	/**
	 * Initialization of the servlet. <br>
	 *
	 * @throws ServletException if an error occurs
	 */
	public void init() throws ServletException {
		// Put your code here
	}
	
	public boolean md5VerifyShan(HttpServletRequest request) throws UnsupportedEncodingException, PayException{
		request.setCharacterEncoding("UTF-8");
		String out_order_no = request.getParameter("out_order_no");
		if("".equals(out_order_no)||out_order_no==null){
			throw new PayException("out_order_no不能为空");
		}
		String total_fee = request.getParameter("total_fee");
		if("".equals(total_fee)||total_fee==null){
			throw new PayException("total_fee不能为空");
		}
		String trade_status  = request.getParameter("trade_status");
		if("".equals(total_fee)||total_fee==null){
			throw new PayException("trade_status不能为空");
		}
		String sign = request.getParameter("sign");
		if("".equals(total_fee)||total_fee==null){
			throw new PayException("sign不能为空");
		}
		String key = Constant.KEY;
		String pid = Constant.PARTNER;
		Md5Util md5Util = new Md5Util();
		String signMd5 = md5Util.encode(out_order_no+total_fee+trade_status+pid+key, null);
		if(signMd5.equals(sign)){
			return true;
		}
		return false;
	}

}
