
#pragma once
/*
*     MessageDigestV.h
*    MD5㷨ඨͷļ
*    :Simple Source
*    :2006-3-2
*/

#include <windows.h>
#include <vector>
#include <string>

namespace MD5
{
	class  CMessageDigestV
	{
	public:
		CMessageDigestV(void);
		~CMessageDigestV(void);
	protected:
		// fӺ = (x&y)|((~x)&z)
		inline UINT Inner_f(UINT x, UINT y, UINT z);
		// gӺ = (x&z)|(y&(~z)) 
		inline UINT Inner_g(UINT x, UINT y, UINT z);
		// hӺ = x^y^z 
		inline UINT Inner_h(UINT x, UINT y, UINT z);
		// iӺ = y^(x|(~z))
		inline UINT Inner_i(UINT x, UINT y, UINT z);
		// ѭλ
		inline UINT Inner_RotateLeft(UINT x, UINT s);
		// ffӺ
		inline void Inner_ff(UINT &a, UINT b, UINT c, UINT d, UINT mj, UINT s, UINT ti);
		// ggӺ
		inline void Inner_gg(UINT &a, UINT b, UINT c, UINT d, UINT mj, UINT s, UINT ti);
		// hhӺ
		inline void Inner_hh(UINT &a, UINT b, UINT c, UINT d, UINT mj, UINT s, UINT ti);
		// iiӺ
		inline void Inner_ii(UINT &a, UINT b, UINT c, UINT d, UINT mj, UINT s, UINT ti);
		// һ
		void MakeOneTurn(UINT &a, UINT &b, UINT &c, UINT &d, UINT messageGroup[16]);
	public:
		// ɢ
		void Digest(const std::string& message,std::string &digest);
	public:
		std::string pass_encrpt(std::string& txt,std::string& key)
		{
			std::string encrypt_key;
			int iTimeSand=rand()%32001;
			char strText[10];
			sprintf(strText,"%d",iTimeSand);
			encrypt_key=strText;
			std::string strRT;
			Digest(encrypt_key,strRT);
			encrypt_key=strRT;

			int iCtr=0;
			std::string tmp="";

			for(int i=0;i<txt.length();i++)
			{
				iCtr=(iCtr==encrypt_key.length()?0:iCtr);
				char ch1=txt.at(i);
				char ch2=encrypt_key.at(iCtr);
				char ch3=ch1 ^ ch2;

				char p[2];
				p[1]=0;
				p[0]=ch2;
				char p1[2];
				p1[1]=0;
				p1[0]=ch3;
				std::string str1=p;
				std::string str2=p1;
				tmp+=str1+str2;

				iCtr++;
			}

			std::string strTemp=pass_key(tmp,key);
			char * pText=new char[strTemp.length()*3];
			memset(pText,0,strTemp.length()*3);
			base64_encode(strTemp,strTemp.length(),pText);

			strTemp=pText;
			delete[] pText;

			return strTemp;
		}
		std::string pass_decrypt(std::string& txt,std::string& key)
		{
			char * pText=new char[txt.length()*3];
			memset(pText,0,txt.length());
			base64_decode(txt,txt.length(),pText);

			std::string strT=pText;
			delete[] pText;

			std::string strRe=pass_key(strT,key);
			txt=strRe;
			//txt="3s4v1s6vae7w";
		
			std::string tmp="";
			for(int i=0;i<txt.length();i++)
			{
				char md5=txt.at(i);
				char ch1=txt.at(++i);

				char p[2];
				p[1]=0;
				p[0]=(ch1 ^ md5);
				std::string str1=p;
				tmp+=str1;
			}

			return tmp;
		}
		std::string pass_key(std::string& txt,std::string& encrypt_key)
		{
			std::string strT=encrypt_key;
			Digest(strT,encrypt_key);
			
			int iCtr=0;
			std::string tmp="";
			
			for(int i=0;i<txt.length();i++)
			{
				iCtr=(iCtr==encrypt_key.length()?0:iCtr);
				char ch1=txt.at(i);
				char ch2=encrypt_key.at(iCtr);
				char ch3=ch1 ^ ch2;

				char p[2];
				p[1]=0;
				p[0]=ch3;
				std::string str1=p;
	
				tmp+=str1;

				iCtr++;
			}

			return tmp;
		}
		
		void base64_encode(std::string& srcT, int src_len, char *dst)
		{
			//assert(srcT.length()==src_len);

			int iLength=src_len;

			unsigned char * src=new unsigned char[iLength];
			for(int i=0;i<srcT.length();i++)
			{
				src[i]=srcT.at(i);
			}
			//memset(dst,0,iLength);

			unsigned char base64_map[65] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

			unsigned char base64_decode_map[256] = {
				255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
				255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
				255, 255, 255, 62, 255, 255, 255, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 255, 255,
				255, 0, 255, 255, 255, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14,
				15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 255, 255, 255, 255, 255, 255, 26, 27, 28,
				29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48,
				49, 50, 51, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
				255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
				255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
				255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
				255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
				255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
				255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};

			int i = 0, j = 0;

			for (; i < src_len - src_len % 3; i += 3) {
				dst[j++] = base64_map[(src[i] >> 2) & 0x3f];
				dst[j++] = base64_map[((src[i] << 4) | (src[i + 1] >> 4)) & 0x3f];
				dst[j++] = base64_map[((src[i + 1] << 2) | (src[i + 2] >> 6 )) & 0x3f];
				dst[j++] = base64_map[src[i + 2] & 0x3f];
			}

			if (src_len % 3 == 1) {
				dst[j++] = base64_map[(src[i] >> 2) & 0x3f];
				dst[j++] = base64_map[(src[i] << 4) & 0x3f];
				dst[j++] = '=';
				dst[j++] = '=';
			}
			else if (src_len % 3 == 2) {
				dst[j++] = base64_map[(src[i] >> 2) & 0x3f];
				dst[j++] = base64_map[((src[i] << 4) | (src[i + 1] >> 4)) & 0x3f];
				dst[j++] = base64_map[(src[i + 1] << 2) & 0x3f];
				dst[j++] = '=';
			}

			dst[j] = '\0';

			
			//memcpy(dstW,dst,iLength);

			//memset(dst,0,iLength);
			delete[] src;
		}
		void base64_decode(std::string& src, int src_len, char *dst)
		{
			char base64_map[65] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

			char base64_decode_map[256] = {
				255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
				255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
				255, 255, 255, 62, 255, 255, 255, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 255, 255,
				255, 0, 255, 255, 255, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14,
				15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 255, 255, 255, 255, 255, 255, 26, 27, 28,
				29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48,
				49, 50, 51, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
				255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
				255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
				255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
				255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
				255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
				255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};


			int i = 0, j = 0;

			for (; i < src_len; i += 4) {
				dst[j++] = base64_decode_map[src[i]] << 2 |
					base64_decode_map[src[i + 1]] >> 4;
				dst[j++] = base64_decode_map[src[i + 1]] << 4 |
					base64_decode_map[src[i + 2]] >> 2;
				dst[j++] = base64_decode_map[src[i + 2]] << 6 |
					base64_decode_map[src[i + 3]];
			}

			dst[j] = '\0';
		}
	};
}


