/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ValidationAware;
import com.opensymphony.xwork2.interceptor.MethodFilterInterceptor;
import com.opensymphony.xwork2.interceptor.ValidationErrorAware;
import com.opensymphony.xwork2.interceptor.ValidationWorkflowAware;
import com.opensymphony.xwork2.interceptor.annotations.InputConfig;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.lang.reflect.Method;

public class DefaultWorkflowInterceptor
extends MethodFilterInterceptor {
    private static final long serialVersionUID = 7563014655616490865L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultWorkflowInterceptor.class);
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private String inputResultName = "input";

    public void setInputResultName(String inputResultName) {
        this.inputResultName = inputResultName;
    }

    protected String doIntercept(ActionInvocation invocation) throws Exception {
        ValidationAware validationAwareAction;
        Object action = invocation.getAction();
        if (action instanceof ValidationAware && (validationAwareAction = (ValidationAware)action).hasErrors()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Errors on action [#0], returning result name [#1]", validationAwareAction, this.inputResultName);
            }
            String resultName = this.inputResultName;
            resultName = this.processValidationWorkflowAware(action, resultName);
            resultName = this.processInputConfig(action, invocation.getProxy().getMethod(), resultName);
            resultName = this.processValidationErrorAware(action, resultName);
            return resultName;
        }
        return invocation.invoke();
    }

    private String processValidationWorkflowAware(Object action, String currentResultName) {
        String resultName = currentResultName;
        if (action instanceof ValidationWorkflowAware) {
            resultName = ((ValidationWorkflowAware)action).getInputResultName();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Changing result name from [#0] to [#1] because of processing [#2] interface applied to [#3]", currentResultName, resultName, InputConfig.class.getSimpleName(), ValidationWorkflowAware.class.getSimpleName(), action);
            }
        }
        return resultName;
    }

    protected String processInputConfig(Object action, String method, String currentResultName) throws Exception {
        String resultName = currentResultName;
        InputConfig annotation = action.getClass().getMethod(method, EMPTY_CLASS_ARRAY).getAnnotation(InputConfig.class);
        if (annotation != null) {
            if (!annotation.methodName().equals("")) {
                Method m = action.getClass().getMethod(annotation.methodName(), new Class[0]);
                resultName = (String)m.invoke(action, new Object[0]);
            } else {
                resultName = annotation.resultName();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Changing result name from [#0] to [#1] because of processing annotation [#2] on action [#3]", currentResultName, resultName, InputConfig.class.getSimpleName(), action);
            }
        }
        return resultName;
    }

    protected String processValidationErrorAware(Object action, String currentResultName) {
        String resultName = currentResultName;
        if (action instanceof ValidationErrorAware) {
            resultName = ((ValidationErrorAware)action).actionErrorOccurred(currentResultName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Changing result name from [#0] to [#1] because of processing interface [#2] on action [#3]", currentResultName, resultName, ValidationErrorAware.class.getSimpleName(), action);
            }
        }
        return resultName;
    }
}

