/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.ServletActionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolesInterceptor
extends AbstractInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(RolesInterceptor.class);
    private boolean isProperlyConfigured = true;
    protected List<String> allowedRoles = Collections.emptyList();
    protected List<String> disallowedRoles = Collections.emptyList();

    public void setAllowedRoles(String roles) {
        this.allowedRoles = this.stringToList(roles);
        this.checkRoles(this.allowedRoles);
    }

    public void setDisallowedRoles(String roles) {
        this.disallowedRoles = this.stringToList(roles);
        this.checkRoles(this.disallowedRoles);
    }

    private void checkRoles(List<String> roles) {
        if (!this.areRolesValid(roles)) {
            LOG.fatal("An unknown Role was configured: #0", new String[]{roles.toString()});
            this.isProperlyConfigured = false;
            throw new IllegalArgumentException("An unknown role was configured: " + roles);
        }
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        if (!this.isProperlyConfigured) {
            throw new IllegalArgumentException("RolesInterceptor is misconfigured, check logs for erroneous configuration!");
        }
        if (!this.isAllowed(request, invocation.getAction())) {
            return this.handleRejection(invocation, response);
        }
        return invocation.invoke();
    }

    protected List<String> stringToList(String val) {
        if (val != null) {
            String[] list = val.split("[ ]*,[ ]*");
            return Arrays.asList(list);
        }
        return Collections.emptyList();
    }

    protected boolean isAllowed(HttpServletRequest request, Object action) {
        for (String role : this.disallowedRoles) {
            if (!request.isUserInRole(role)) continue;
            return false;
        }
        if (this.allowedRoles.isEmpty()) {
            return true;
        }
        for (String role : this.allowedRoles) {
            if (!request.isUserInRole(role)) continue;
            return true;
        }
        return false;
    }

    protected String handleRejection(ActionInvocation invocation, HttpServletResponse response) throws Exception {
        response.sendError(403);
        return null;
    }

    protected boolean areRolesValid(List<String> roles) {
        return true;
    }
}

