﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Data;
using System.Text;
using System.Data.SqlClient;
namespace GridDemos
{
    /// <summary>
    /// grid1 的摘要说明
    /// </summary>
    public class grid1 : IHttpHandler
    {

        public void ProcessRequest(HttpContext context)
        {
            context.Response.ContentType = "text/plain";
            string action=context.Request["action"];
            switch (action)
            {
                case "query":
                    Query();
                    break;
                case "del":
                    Del();
                    break;
                case "add":
                    Add();
                    break;
                case "edit":
                    Edit();
                    break;
            }
        }
        /// <summary>
        /// 查询的方法
        /// </summary>
        private void Query()
        {
            //一页显示几行数据
            string rows = HttpContext.Current.Request["rows"];
            //当前页
            string page=HttpContext.Current.Request["page"];
            //获取分页的数据源
            DataTable dt1 = SqlHelper.Proc_Table("pageFilter", int.Parse(rows), int.Parse(page), "stu");
            //获取数据源
            DataTable dt = SqlHelper.GetTable("select * from stu");
            string str = string.Empty;
            //将数据转换成json格式
            str = JSonHelper.CreateJsonParameters(dt1, true, dt.Rows.Count);
            HttpContext.Current.Response.Write(str);
        }
        //删除的方法
        private void Del()
        {
            //获取到选中行的id
            string id = HttpContext.Current.Request["id"];
            int count = 0;
            count = SqlHelper.DelData("stu",id);
            if (count > 0)
            {
                HttpContext.Current.Response.Write("共删除了"+count+"条数据");
            }
            else
            {
                HttpContext.Current.Response.Write("error");
            }
        }
        //添加
        private void Add()
        {
            StringBuilder sb = new StringBuilder();
            //遍历获取传递过来的字符串
            foreach (string s in HttpContext.Current.Request.Form.AllKeys)
            {
                sb.AppendFormat("{0}:{1}\n",s,HttpContext.Current.Request.Form[s]);
            }
            string ss = sb.ToString();
            string[]str=ss.Split('&');
            string no=str[0].Split('=')[1];
            string name = str[1].Split('=')[1];
            string pwd = str[2].Split('=')[1];
            string sex = str[3].Split('=')[1]=="1"?"男":"女";
            int age = int.Parse(str[4].Split('=')[1]);
            string address = str[5].Split('=')[1];
            SqlParameter[] parms = {
                            new SqlParameter("@no",no),
                            new SqlParameter("@name",name),
                            new SqlParameter("@pwd",pwd),
                            new SqlParameter("@sex",sex),
                            new SqlParameter("@age",age),
                            new SqlParameter("@address",address)
                                 };
            bool flag = SqlHelper.ExeNonQuery("insert_stu", CommandType.StoredProcedure, parms);
            if (flag)
            {
                HttpContext.Current.Response.Write("添加成功！");
            }
            else
            {
                HttpContext.Current.Response.Write("添加失败！");
            }
        }

        private void Edit()
        {
            StringBuilder sb = new StringBuilder();
            //遍历获取传递过来的字符串
            foreach (string s in HttpContext.Current.Request.Form.AllKeys)
            {
                sb.AppendFormat("{0}:{1}\n", s, HttpContext.Current.Request.Form[s]);
            }
            string ss = sb.ToString();
            string[] str = ss.Split('&');
            int id = int.Parse(str[0].Split('=')[1]);
            string no = str[1].Split('=')[1];
            string name = str[2].Split('=')[1];
            string pwd = str[3].Split('=')[1];
            string sex = str[4].Split('=')[1] == "1" ? "男" : "女";
            int age = int.Parse(str[5].Split('=')[1]);
            string address = str[6].Split('=')[1];
            SqlParameter[] parms = {
                            new SqlParameter("@no",no),
                            new SqlParameter("@name",name),
                            new SqlParameter("@pwd",pwd),
                            new SqlParameter("@sex",sex),
                            new SqlParameter("@age",age),
                            new SqlParameter("@address",address),
                            new SqlParameter("@id",id)
                                 };
            bool flag = SqlHelper.ExeNonQuery("up_stu", CommandType.StoredProcedure, parms);
            if (flag)
            {
                HttpContext.Current.Response.Write("修改成功！");
            }
            else
            {
                HttpContext.Current.Response.Write("修改失败！");
            }
        }
        public bool IsReusable
        {
            get
            {
                return false;
            }
        }
    }
}