﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using ClothesSys.DAL;
using ClothesSys.Model;

namespace ClothesSys.BLL
{
    public class BillManager
    {
        public static DataTable GetBillsOfTableToday()
        {
            return BillService.GetBillsOfTableToday();
        }

        public static Bill GetBillByBillId(string bid)
        {
            return BillService.GetBillByBillId(bid);
        }

        public static Bill GetBillBySellId(string sid)
        {
            return BillService.GetBillBySellId(sid);
        }

        public static DataTable GetBillsByBillId(string bid)
        {
            return BillService.GetBillsByBillId(bid);
        }

        public static DataTable GetBillsByCustomerId(string cid)
        {
            return BillService.GetBillsByCustomerId(cid);
        }


        public static string[] GetAllBillId()
        {
            List<Bill> listb = BillService.GetAllBills();
            List<string> lbids = new List<string>();
            foreach (Bill bill in listb)
            {
                lbids.Add(bill.BillId);
 
            }

            return lbids.ToArray();
        }
    }
}
