﻿using System;
using System.Collections.Generic;
using System.Text;
using ClothesSys.DAL;
using ClothesSys.Model;
using System.Data;

namespace ClothesSys.BLL
{
    public class CustomerManager
    {
        public static bool AddCustomer(Customer ct)
        {
            int i = CustomerService.AddCustomer(ct);
            if (i > 0)
            {
                return true;
            }
            else
            {
                return false;
            }
        }

        public static bool UpdateCustomer(string oldid, Customer ct)
        {
            int i = CustomerService.UpdateCustomer(oldid, ct);
            if (i > 0)
            {
                return true;
            }
            else
            {
                return false;
            }

        }

        

        public static DataTable GetAllCustomersOfTable()
        {
            return CustomerService.GetAllCustomersOfTable();
        }

        public static Customer GetCustomerById(string id)
        {
            return CustomerService.GetCustomerById(id);
        }

        public static bool DeleteCustomerById(string id)
        {
            int i = CustomerService.DeleteCustomerById(id);
            if (i > 0)
            {
                return true;
            }
            else
            {
                return false;
            }
        }

        public static string[] GetCustomersId()
        {
            List<Customer> list = CustomerService.GetCustomersID();
            List<string> strs = new List<string>();
            foreach (Customer c in list)
            {
                strs.Add(c.CustomerID);

            }

            return strs.ToArray();

        }

    }
}
