﻿using System;
using System.Collections.Generic;
using System.Text;
using ClothesSys.DAL;
using ClothesSys.Model;
using System.Data;

namespace ClothesSys.BLL
{
    public class GoodCategoryManager
    {
        public static DataTable GetAllGoodCategoryOfTable()
        {
            return GoodCategoryService.GetAllGoodCategoryOfTable();
        }

        public static bool AddGoodCategory(string cname)
        {
            int i = GoodCategoryService.AddCategory(cname);
            if (i > 0)
            {
                return true;
            }
            else
            {
                return false;
            }
        }

        public static bool UpdateGoodCategory(string id, string name)
        {
            GoodCategory gc = new GoodCategory();
            gc.GoodCategoryId = Convert.ToInt32(id);
            gc.GoodCategoryName = name;

            GoodCategory oldgc = GetCategoryByCategoryId(id);

            int i = GoodCategoryService.UpdateCategory(oldgc.GoodCategoryName, gc);
            if (i > 0)
            {
                return true;
            }
            else
            {
                return false;
            }

        }

        public static GoodCategory GetCategoryByCategoryId(string cid)
        {
            return GoodCategoryService.GetCategoryByCategoryId(cid);
        }

        

        public static bool DeleteGoodCategoryById(string id)
        {
            int i = GoodCategoryService.DeleteGoodCategoryById(id);
            if (i > 0)
            {
                return true;
            }
            else
            {
                return false;
            }
        }
    }
}
