﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using ClothesSys.DAL;
using ClothesSys.Model;

namespace ClothesSys.BLL
{
    public class GoodManager
    {
        public static DataTable GetAllGoodsOfTable()
        {
            return GoodService.GetAllGoodsOfTable();
 
        }

        public static bool AddGood(Good good)
        {
            int i = GoodService.AddGood(good);
            if (i > 0)
            {
                return true;
            }
            else
            {
                return false;
            }
        }

        public static Good GetGoodById(string id)
        {
            return GoodService.GetGoodById(id);
        }

        public static bool UpdateGood(string oid, Good g)
        {
            int i = GoodService.UpdateGood(oid, g);
            if (i > 0)
            {
                return true;
            }
            else
            {
                return false;
            }
        }

        public static bool DeleteGoodById(string id)
        {
            int i = GoodService.DeleteGoodById(id);
            if (i > 0)
            {
                return true;
            }
            else
            {
                return false;
            }
        }


        /// <summary>
        /// 根据CategoryId获得Good表
        /// </summary>
        /// <param name="cid">CategoryId</param>
        /// <returns></returns>
        public static DataTable GetGoodsByCategoryId(string cid)
        {
            return GoodService.GetGoodsByCategoryId(cid);
        }


        public static List<Good> GetGoods()
        {
            return GoodService.GetGoods();
        }
    }
}
