﻿using System;
using System.Collections.Generic;
using System.Text;
using ClothesSys.DAL;
using ClothesSys.Model;
using System.Data;



namespace ClothesSys.BLL
{
    public class SellManager
    {
        public static DataTable GetSellRecordsOfToday()
        {
            return SellService.GetSellRecordsOfToday();
        }

        public static DataTable GetSellRecordsByDay(DateTime start,DateTime end)
        {
            return SellService.GetSellRecordsByDay(start, end);
        }

        public static bool AddSells(List<Sell> list)
        {
            return SellService.AddSells(list);
        }

        public static string GetSellId()
        {
            return DateTime.Now.ToString("yyyyMMddHHmmss");
        }

        public static bool DeleteSellBySellId(string sid)
        {
            int i = SellService.DeleteSellBySellId(sid);
            if (i > 0)
            {
                return true;
            }
            else
            {
                return false;
            }
        }

        public static Sell GetSellBySellID(string sid)
        {
            return SellService.GetSellBySellId(sid);
        }

        

        
    }
}
