﻿using System;
using System.Collections.Generic;
using System.Text;
using ClothesSys.DAL;
using ClothesSys.Model;
using System.Data;

namespace ClothesSys.BLL
{
    public class UserManager
    {



        /// <summary>
        /// 根据用户ID取得用户对象
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public static User GetUserByID(string id)
        {

            return UserService.GetUserByID(id);
        }


        /// <summary>
        /// 添加用户
        /// </summary>
        /// <param name="userid"></param>
        /// <param name="name"></param>
        /// <param name="password"></param>
        /// <returns></returns>
        public static bool AddUser(string userid, string name, string password)
        {
            
            User user = new User(userid,name,password);
            int i = UserService.AddUser(user);
            if (i > 0)
            {
                return true;
            }
            else
            {
                return false;
            }
        }

        /// <summary>
        /// 用户登录
        /// </summary>
        /// <param name="userid"></param>
        /// <param name="password"></param>
        /// <param name="user">登陆成功后,返回user</param>
        /// <returns></returns>
        public static bool Login(string userid, string password, out User user)
        {
            User currentUser = UserService.GetUserByID(userid);

            if (currentUser == null)
            {
                user = null;
                return false;
 
            }
            else if (currentUser.Password == password)
            {
                user = currentUser;
                return true;
            }
            else
            {
                user = null;
                return false;
            }

        }


        public static DataTable GetAllUsersOfTable()
        {
            return UserService.GetAllUsersOfTable();
        }


        public static List<User> GetAllUsers()
        {
            return UserService.GetAllUsers();
        }


        /// <summary>
        /// 更新操作员信息
        /// </summary>
        /// <param name="user"></param>
        /// <returns></returns>
        public static bool UpdateUser(User user)
        {
            int i = UserService.UpdateUser(user);
            if (i > 0)
            {
                return true;
            }
            else
            {
                return false;
            }
        }



        public static bool DeleteUserById(string uid)
        {
            int i = UserService.DeleteUserByID(uid);
            if (i > 0)
            {
                return true;
            }
            else
            {
                return false;
            }
        }

        
    }
}
