﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;



namespace ClothesSys.Common
{
    public class CommonUtility
    {
        /// <summary>
        /// 键盘只允许输入数字
        /// </summary>
        /// <param name="e"></param>
        public static void ValidateNumber(KeyPressEventArgs e)
        {
            e.Handled = true;
            if (e.KeyChar >= '0' && e.KeyChar <= '9' || e.KeyChar == '\b')  //只允许输入数字，-，退格键
            {
                e.Handled = false;
            }
        }


        /// <summary>
        /// 键盘只允许输入数字（还有'-'）
        /// </summary>
        /// <param name="e"></param>
        public static void ValidateTel(KeyPressEventArgs e)
        {
            e.Handled = true;
            if (e.KeyChar >= '0' && e.KeyChar <= '9' || e.KeyChar == '-' || e.KeyChar == '\b')  //只允许输入数字，-，退格键
            {
                e.Handled = false;
            }

        }

        /// <summary>
        /// 验证是否所有TextBox都不为空,若都不为空,
        /// </summary>
        /// <param name="cls"></param>
        /// <returns></returns>
        public static bool ValidateTexbBoxesEmpty(Control.ControlCollection cls)
        {            
            foreach (Control c in cls)
            {
                if (c is TextBox)
                {
                    TextBox tb = (TextBox)c;
                    if (tb.Text == "")
                    {
                        return false;
                    }
                }
           
            }
            
            return true;
        }



        /// <summary>
        /// 设置所有TextBox为ReadOnly=true
        /// </summary>
        /// <param name="cls"></param>
        public static void SetAllTextBoxReadOnly(Control.ControlCollection cls)
        {
            foreach (Control c in cls)
            {
                if (c is TextBox)
                {
                    TextBox tb = (TextBox)c;
                    tb.ReadOnly = true;
                }

            }
 
        }


        public static string ChangeTimeToStr(DateTime time)
        {
            return time.ToString("yyyyMMddhhmmss");
        }

        

        

    }
}
