﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ClothesSys.BLL;
using ClothesSys.Model;

namespace ClothesSys.CompanyManage
{
    public partial class formCompanyAdd : Form
    {

        ucCompanyManage ucCM;
        public formCompanyAdd()
        {
            InitializeComponent();
        }

        public formCompanyAdd(ucCompanyManage uc)
        {
            InitializeComponent();
            ucCM = uc;
        }

        private void btnAdd_Click(object sender, EventArgs e)
        {
            string name = txbName.Text;
            string tel = txbTel.Text;
            string address = txbAddress.Text;

            if (name != "" && tel != "" && address != "")
            {
                Company com = new Company(name, tel, address);
                bool f = CompanyManager.AddCompany(com);
                if (f)
                {
                    MessageBox.Show("添加成功!", "提示");
                    ucCM.bindDgvCompany();
                    this.Close();
                }
                else
                {
                    MessageBox.Show("添加失败!", "提示");
                }
            }
            else
            {
                MessageBox.Show("请填写完整信息!", "提示");
 
            }
        }

        private void txbTel_KeyPress(object sender, KeyPressEventArgs e)
        {
            e.Handled = true;
            if(e.KeyChar>='0'&&e.KeyChar<='9'||e.KeyChar=='-'||e.KeyChar=='\b')  //只允许输入数字，-，退格键
            {
                e.Handled = false; 
            }
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }
    }
}
