﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ClothesSys.Model;
using ClothesSys.BLL;

namespace ClothesSys.CompanyManage
{
    public partial class formCompanyUpdate : Form
    {
        ucCompanyManage ucCM;
        Company com;
        public formCompanyUpdate()
        {
            InitializeComponent();
        }

        public formCompanyUpdate(string cid,ucCompanyManage ucm)
        {
            InitializeComponent();
            ucCM = ucm;
            com = CompanyManager.GetCompanyById(cid);
            txbName.Text = com.CompanyName;
            txbAddress.Text = com.CompanyAddress;
            txbTel.Text = com.CompanyTel;
        }

        private void btnAdd_Click(object sender, EventArgs e)
        {
            string name = txbName.Text;
            string tel = txbTel.Text;
            string address = txbAddress.Text;

            if (name != "" && tel != "" && address != "")
            {
                com.CompanyName = name;
                com.CompanyAddress = address;
                com.CompanyTel = tel;
                bool f = CompanyManager.UpdateCompany(com);
                if (f)
                {
                    MessageBox.Show("修改成功!", "提示");
                    ucCM.bindDgvCompany();
                    this.Close();
                }
                else
                {
                    MessageBox.Show("修改失败!", "提示");
                }
            }
            else
            {
                MessageBox.Show("请填写完整信息!", "提示");

            }
        }

        private void txbTel_KeyPress(object sender, KeyPressEventArgs e)
        {
            e.Handled = true;
            if(e.KeyChar>='0'&&e.KeyChar<='9'||e.KeyChar=='-'||e.KeyChar=='\b')  //只允许输入数字，-，退格键
            {
                e.Handled = false; 
            }
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }
    }
}
