﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ClothesSys.BLL;
using ClothesSys.Model;
using ClothesSys.UC;

namespace ClothesSys.CustomerManage
{
    public partial class formCustomerAdd : Form
    {

        ucCustomerManage ucCM;
        public formCustomerAdd()
        {
            InitializeComponent();
        }

        public formCustomerAdd(ucCustomerManage uc)
        {
            InitializeComponent();
            ucCM = uc;
        }

        private void txbId_KeyPress(object sender, KeyPressEventArgs e)
        {
            e.Handled = true;
            if (e.KeyChar >= '0' && e.KeyChar <= '9' || e.KeyChar == '\b')  //只允许输入数字，-，退格键
            {
                e.Handled = false;
            }
        }

        private void btnAdd_Click(object sender, EventArgs e)
        {

            string name = txbName.Text;
            string score = txbSocre.Text;
            string id = txbId.Text;
            string remark = txbRemark.Text;

            if (name != "" && id != "")
            {
                Customer ct = new Customer();
                ct.CustomerID = id;
                ct.CustomerName = name;
                ct.Remark = remark;
                ct.Socre = Convert.ToInt32(score);

                bool f = CustomerManager.AddCustomer(ct);
                if (f)
                {
                    MessageBox.Show("添加成功!", "提示");
                    this.Close();
                    ucCM.bindDgvCustomers();
                }
                else
                {
                    MessageBox.Show("添加失败,已存在该相同ID/手机号!", "提示");
                }
            }
            else
            {
                MessageBox.Show("请填写完整信息!", "提示");
 
            }


        }

        private void txbSocre_KeyPress(object sender, KeyPressEventArgs e)
        {
            e.Handled = true;
            if (e.KeyChar >= '0' && e.KeyChar <= '9' || e.KeyChar == '\b')  //只允许输入数字，-，退格键
            {
                e.Handled = false;
            }

        }

        private void formCustomerAdd_Load(object sender, EventArgs e)
        {
            txbSocre.Text = "0";
            txbRemark.Text = "无";

        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        

        
    }
}
