﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ClothesSys.Model;
using ClothesSys.BLL;
using ClothesSys.UC;

namespace ClothesSys.CustomerManage
{
    public partial class formCustomerUpdate : Form
    {
        string oldId;
        ucCustomerManage ucCM;
        public formCustomerUpdate()
        {
            InitializeComponent();
        }

        public formCustomerUpdate(string oid,ucCustomerManage uc)
        {
            InitializeComponent();
            oldId = oid;
            ucCM = uc;
        }

        private void txbId_KeyPress(object sender, KeyPressEventArgs e)
        {
            e.Handled = true;
            if (e.KeyChar >= '0' && e.KeyChar <= '9' || e.KeyChar == '\b')  //只允许输入数字，-，退格键
            {
                e.Handled = false;
            }
        }

        private void txbSocre_KeyPress(object sender, KeyPressEventArgs e)
        {
            e.Handled = true;
            if (e.KeyChar >= '0' && e.KeyChar <= '9' || e.KeyChar == '\b')  //只允许输入数字，-，退格键
            {
                e.Handled = false;
            }
        }

        private void btnUpdate_Click(object sender, EventArgs e)
        {
            string name = txbName.Text;
            string score = txbSocre.Text;
            string id = txbId.Text;
            string remark = txbRemark.Text;

            if (id != "" && name != "")
            {
                Customer ct = new Customer();
                ct.CustomerID = id;
                ct.CustomerName = name;
                ct.Socre = Convert.ToInt32(score);
                ct.Remark = remark;
                bool f = CustomerManager.UpdateCustomer(oldId, ct);
                if (f)
                {
                    MessageBox.Show("修改成功!", "提示");
                    ucCM.bindDgvCustomers();
                    this.Close();
                }
                else
                {
                    MessageBox.Show("修改失败,已存在相同ID/手机号!", "提示");
                }

 
            }
        }

        private void formCustomerUpdate_Load(object sender, EventArgs e)
        {
            Customer ct = CustomerManager.GetCustomerById(oldId);
            txbId.Text = ct.CustomerID;
            txbName.Text = ct.CustomerName;
            txbSocre.Text = ct.Socre.ToString();
            txbRemark.Text = ct.Remark;
            
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        
    }
}
