﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ClothesSys.BLL;
using ClothesSys.UC;
using ClothesSys.Model;

namespace ClothesSys.GoodCategoryManage
{
    public partial class formCategoryUpdate : Form
    {
        string categoryId;
        ucGoodCategoryManage ucGM;
        public formCategoryUpdate()
        {
            InitializeComponent();
        }

        public formCategoryUpdate(string id,ucGoodCategoryManage uc)
        {
            InitializeComponent();
            categoryId = id;
            ucGM = uc;
            GoodCategory gc = GoodCategoryManager.GetCategoryByCategoryId(id);
            txbName.Text = gc.GoodCategoryName;
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void btnUpdate_Click(object sender, EventArgs e)
        {
            string name = txbName.Text;
            if (name != "")
            {
                bool f = GoodCategoryManager.UpdateGoodCategory(categoryId, name);
                if (f)
                {
                    MessageBox.Show("修改成功!", "提示");
                    this.Close();
                    ucGM.bindLsbGc();
                }
                else
                {
                    MessageBox.Show("修改失败,已存在同名服装类别!", "提示");

                }
            }
            else
            {
                MessageBox.Show("请填写服装类别!", "提示");
 
            }
        }
    }
}
