﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ClothesSys.Model;
using ClothesSys.BLL;
using ClothesSys.UC;

namespace ClothesSys.FormGoodManage
{
    public partial class formGoodAdd : Form
    {

        ucGoodManage ucGM;
        public formGoodAdd()
        {
            InitializeComponent();
        }
        public formGoodAdd(ucGoodManage uc)
        {
            InitializeComponent();
            ucGM = uc;
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void btnAdd_Click(object sender, EventArgs e)
        {
            string id = txbID.Text;
            string name = txbName.Text;
            string remark = txbRemark.Text;
            string area = txbProduceArea.Text;
            int categoryid = Convert.ToInt32(cmbCategory.SelectedValue);


            if (id != "" && name != "")
            {
                Good good = new Good();
                good.GoodID = id;
                good.GoodName = name;
                good.ProduceArea = area;
                good.Remark = remark;
                good.CategoryID = categoryid;
                bool f = GoodManager.AddGood(good);
                if (f)
                {
                    MessageBox.Show("添加成功!", "提示");
                    this.Close();
                    ucGM.bindDgvGood();

                }
                else
                {
                    MessageBox.Show("已存在相同服装ID,添加失败!", "提示");

                }

            }
            else
            {
                MessageBox.Show("请填写完整信息!", "提示");
 
            }



        }

        private void formGoodAdd_Load(object sender, EventArgs e)
        {
            bindCmbCategory();
            txbRemark.Text = "无";
            txbProduceArea.Text = "中国";
        }

        private void bindCmbCategory()
        {
            cmbCategory.DataSource = GoodCategoryManager.GetAllGoodCategoryOfTable();
            cmbCategory.DisplayMember = "goodCategoryName";
            cmbCategory.ValueMember = "goodCategoryId";
            cmbCategory.SelectedIndex = 0;
        }
    }
}
