﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ClothesSys.Model;
using ClothesSys.BLL;
using ClothesSys.UC;

namespace ClothesSys.FormGoodManage
{
    public partial class formGoodUpdate : Form
    {
        string goodId;
        ucGoodManage ucGM;
        public formGoodUpdate()
        {
            InitializeComponent();
        }

        public formGoodUpdate(string id,ucGoodManage uc)
        {
            InitializeComponent();
            goodId = id;
            ucGM = uc;
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void formGoodUpdate_Load(object sender, EventArgs e)
        {
            bindCmbCategory();
            Good good = GoodManager.GetGoodById(goodId);
            txbID.Text = good.GoodID;
            txbName.Text = good.GoodName;
            txbProduceArea.Text = good.ProduceArea;
            txbRemark.Text = good.Remark;
            cmbCategory.SelectedValue = good.CategoryID;
            
        }

        private void bindCmbCategory()
        {
            cmbCategory.DataSource = GoodCategoryManager.GetAllGoodCategoryOfTable();
            cmbCategory.DisplayMember = "goodCategoryName";
            cmbCategory.ValueMember = "goodCategoryId";
            
        }

        private void btnUpdate_Click(object sender, EventArgs e)
        {
            string id = txbID.Text;
            string name = txbName.Text;
            string area = txbProduceArea.Text;
            string remark = txbRemark.Text;
            int categoryid = Convert.ToInt32(cmbCategory.SelectedValue);

            Good good = new Good();
            good.GoodID = id;
            good.GoodName = name;
            good.ProduceArea = area;
            good.Remark = remark;
            good.CategoryID = categoryid;

            bool f = GoodManager.UpdateGood(goodId, good);
            if (f)
            {
                MessageBox.Show("修改成功!", "提示");
                this.Close();
                ucGM.bindDgvGood();
            }
            else
            {
                MessageBox.Show("已存在相同服装ID,修改失败!", "提示");
 
            }
        }
    }
}
