﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ClothesSys.BLL;
using ClothesSys.Model;
using ClothesSys.Common;
using ClothesSys.UC;

namespace ClothesSys.FormReGoodsManage
{
    public partial class FormReGood : Form
    {
        string userId;
        string sellId;
        ucReGoodManage ucGRM;
        public FormReGood(string uid,ucReGoodManage uc)
        {
            InitializeComponent();
            userId = uid;
            ucGRM = uc;
        }

        

        void bindTxbCustomerID()
        {
            var source = new AutoCompleteStringCollection();


            txbCustomerID.AutoCompleteCustomSource.AddRange(CustomerManager.GetCustomersId());
            txbCustomerID.AutoCompleteSource = AutoCompleteSource.CustomSource;
            txbCustomerID.AutoCompleteMode = AutoCompleteMode.SuggestAppend;
            

        }

        void bindTxbBillId()
        {
            var source = new AutoCompleteStringCollection();
            txbBillId.AutoCompleteCustomSource.AddRange(BillManager.GetAllBillId());
            txbBillId.AutoCompleteSource = AutoCompleteSource.CustomSource;
            txbBillId.AutoCompleteMode = AutoCompleteMode.SuggestAppend;
        }



        private void txbReGoodsNum_TextChanged(object sender, EventArgs e)
        {
            if (txbReGoodsNum.Text != "" && txbReGoodsPrice.Text != "")
            {
                int goodPrice = Convert.ToInt32(txbReGoodsPrice.Text);
                int sellNum = Convert.ToInt32(txbReGoodsNum.Text);
                int needPay = goodPrice * sellNum;
                txbReNeedPay.Text = needPay.ToString();
            }
        }

        private void txbReGoodsPrice_TextChanged(object sender, EventArgs e)
        {
            if (txbReGoodsNum.Text != "" && txbReGoodsPrice.Text != "")
            {
                int goodPrice = Convert.ToInt32(txbReGoodsPrice.Text);
                int sellNum = Convert.ToInt32(txbReGoodsNum.Text);
                int needPay = goodPrice * sellNum;
                txbReNeedPay.Text = needPay.ToString();
            }

        }

        void bindCmbCustomer()
        {
            cmbCustomer.DataSource = CustomerManager.GetAllCustomersOfTable();

            cmbCustomer.DisplayMember = "CustomerName";
            cmbCustomer.ValueMember = "CustomerId";

            cmbCustomer.SelectedIndex = 0;
            txbCustomerID.Text = cmbCustomer.SelectedValue.ToString();

        }

        void bindCmbUser()
        {
            cmbUser.DataSource = UserManager.GetAllUsersOfTable();
            cmbUser.DisplayMember = "Name";
            cmbUser.ValueMember = "UserId";
            cmbUser.SelectedValue = userId;
        }

        private void FormReGood_Load(object sender, EventArgs e)
        {
            bindCmbCustomer();
            bindCmbUser();
            bindTxbCustomerID();
            bindTxbBillId();
        }


        private void txbCustomerID_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Enter)
            {
                //cmbCustomer.ResetText();
                string customerId = txbCustomerID.Text;
                if (CustomerManager.GetCustomerById(customerId).CustomerID != null)
                {

                    cmbCustomer.SelectedValue = customerId;

                }
                else
                {
                    cmbCustomer.SelectedIndex = -1;
                }

            }
        }

        private void cmbCustomer_DropDownClosed(object sender, EventArgs e)
        {
            txbCustomerID.Text = cmbCustomer.SelectedValue.ToString();
        }

        private void btnSearchByBillId_Click(object sender, EventArgs e)
        {
            string billId = txbBillId.Text;
            if (billId != "")
            {
                bindDgvReGoodsByBillId(billId);
            }
        }

        private void bindDgvReGoodsByBillId(string billId)
        {

            //T_sell.sellId,selltime,goodname,goodsprice,sellnum,realpay,customerId
            dgvReGoodsByBillId.DataSource = BillManager.GetBillsByBillId(billId);
            dgvReGoodsByBillId.Columns["sellId"].Visible = false;
            dgvReGoodsByBillId.Columns["sellTime"].HeaderText = "销售时间";
            dgvReGoodsByBillId.Columns["sellTime"].AutoSizeMode = DataGridViewAutoSizeColumnMode.DisplayedCells;  //让"销售时间"显示完整
            dgvReGoodsByBillId.Columns["goodName"].HeaderText = "服装名称";
            dgvReGoodsByBillId.Columns["goodsPrice"].HeaderText = "单价";
            dgvReGoodsByBillId.Columns["sellNum"].HeaderText = "销售数量";
            dgvReGoodsByBillId.Columns["realPay"].HeaderText = "实际支付";
            dgvReGoodsByBillId.Columns["customerId"].HeaderText = "顾客ID";

            dgvReGoodsByBillId.AllowUserToAddRows = false;
            dgvReGoodsByBillId.SelectionMode = DataGridViewSelectionMode.FullRowSelect;
            dgvReGoodsByBillId.AutoSizeColumnsMode = DataGridViewAutoSizeColumnsMode.Fill;
            

        }

        private void btnSearchByCustomer_Click(object sender, EventArgs e)
        {
            string customerId = txbCustomerID.Text;
            if (customerId != "")
            {
                bindDgvReGoodsByCustomerId(customerId);
            }
        }

        private void bindDgvReGoodsByCustomerId(string customerId)
        {
            dgvReGoodsByCustomer.DataSource = BillManager.GetBillsByCustomerId(customerId);

            //T_sell.sellId,selltime,goodname,goodsprice,sellnum,realpay,customerId
            
            dgvReGoodsByCustomer.Columns["sellId"].Visible = false;
            dgvReGoodsByCustomer.Columns["sellTime"].HeaderText = "销售时间";
            dgvReGoodsByCustomer.Columns["sellTime"].AutoSizeMode = DataGridViewAutoSizeColumnMode.DisplayedCells;
            dgvReGoodsByCustomer.Columns["goodName"].HeaderText = "服装名称";
            dgvReGoodsByCustomer.Columns["goodsPrice"].HeaderText = "单价";
            dgvReGoodsByCustomer.Columns["sellNum"].HeaderText = "销售数量";
            dgvReGoodsByCustomer.Columns["realPay"].HeaderText = "实际支付";
            dgvReGoodsByCustomer.Columns["customerId"].HeaderText = "顾客ID";

            dgvReGoodsByCustomer.AllowUserToAddRows = false;
            dgvReGoodsByCustomer.SelectionMode = DataGridViewSelectionMode.FullRowSelect;
            dgvReGoodsByCustomer.AutoSizeColumnsMode = DataGridViewAutoSizeColumnsMode.Fill;
        }

        private void dgvReGoodsByBillId_CellEnter(object sender, DataGridViewCellEventArgs e)
        {
            if (e.RowIndex >= 0)
            {
                sellId = dgvReGoodsByBillId.Rows[e.RowIndex].Cells["sellId"].Value.ToString();
                bindTextBoxOfReGood(sellId);
            }
        }

        private void dgvReGoodsByCustomer_CellEnter(object sender, DataGridViewCellEventArgs e)
        {
            if (e.RowIndex >= 0)
            {
                sellId = dgvReGoodsByCustomer.Rows[e.RowIndex].Cells["sellId"].Value.ToString();
                bindTextBoxOfReGood(sellId);
            }
        }

        void bindTextBoxOfReGood(string sid)
        {
            Sell sell = SellManager.GetSellBySellID(sid);
            if (sell != null)
            {
                Good good = GoodManager.GetGoodById(sell.GoodsId);
                GoodCategory goodCategory = GoodCategoryManager.GetCategoryByCategoryId(good.CategoryID.ToString());
                txbGoodId.Text = sell.GoodsId;
                txbGoodName.Text = good.GoodName;
                txbGoodCategoryName.Text = goodCategory.GoodCategoryName;
                txbReGoodsPrice.Text = sell.GoodsPrice.ToString();
                txbReGoodsNum.Text = sell.SellNum.ToString();
                
            }
        }

        private void btnReGoodSubmit_Click(object sender, EventArgs e)
        {
            if (CommonUtility.ValidateTexbBoxesEmpty(this.groupBox2.Controls))
            {
                string regoodId = txbGoodId.Text;
                int regoodsPrice = Convert.ToInt32(txbReGoodsPrice.Text);
                int regoodsNum = Convert.ToInt32(txbReGoodsNum.Text);
                int reNeedPay = Convert.ToInt32(txbReNeedPay.Text);
                int reRealPay = Convert.ToInt32(txbReRealPay.Text);
                string regoodResult = txbReGoodsResult.Text;
                DateTime regoodTime = DateTime.Now;
                string userId = cmbUser.SelectedValue.ToString();

                ReGoods regood = new ReGoods();
                regood.ReGoodsID = regoodId;
                regood.ReGoodsPrice = regoodsPrice;
                regood.ReGoodsNum = regoodsNum;
                regood.ReNeedPay = reNeedPay;
                regood.ReRealPay = reRealPay;
                regood.ReGoodResult = regoodResult;
                regood.RegoodsTime = regoodTime;
                regood.UserId = userId;
                regood.SellId = sellId;

                if (ReGoodsManager.ReGoodSumbit(regood))
                {
                    MessageBox.Show("退货成功!", "提示");
                    this.Close();
                    ucGRM.bindDgvRegoods();
                }

            }
            else
            {
                MessageBox.Show("请选择退货服装,并填写完整信息!", "提示");
            }
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void txbReGoodsPrice_KeyPress(object sender, KeyPressEventArgs e)
        {
            CommonUtility.ValidateNumber(e);
        }

        private void txbReGoodsNum_KeyPress(object sender, KeyPressEventArgs e)
        {
            CommonUtility.ValidateNumber(e);
        }

        private void txbReRealPay_KeyPress(object sender, KeyPressEventArgs e)
        {
            CommonUtility.ValidateNumber(e);
        }
    }
}
