﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ClothesSys.Model;
using ClothesSys.BLL;
using ClothesSys.Common;

namespace ClothesSys.FormReGoodsManage
{
    public partial class FormReGoodDetail : Form
    {
        string reGoodsBillId;
        public FormReGoodDetail(string regbid)
        {
            InitializeComponent();
            reGoodsBillId = regbid;
        }

        private void FormReGoodDetail_Load(object sender, EventArgs e)
        {
            InitialTextbox();
            bindTextBox();
        }

        void InitialTextbox()
        {
            CommonUtility.SetAllTextBoxReadOnly(this.groupBox1.Controls);
            CommonUtility.SetAllTextBoxReadOnly(this.groupBox2.Controls);
 
        }


        void bindTextBox()
        {
             ReGoods regood = ReGoodsManager.GetReGoodsByReGoodsBillId(reGoodsBillId);
             if (regood != null)
             {

                 Sell sell = SellManager.GetSellBySellID(regood.SellId);
                 Customer customer = CustomerManager.GetCustomerById(sell.CustomerID);
                 Good good = GoodManager.GetGoodById(regood.ReGoodsID);
                 GoodCategory goodCategory = GoodCategoryManager.GetCategoryByCategoryId(good.CategoryID.ToString());
                 int stockNum = StockManager.GetStockNumByGoodId(regood.ReGoodsID);
                 //退货单信息
                 txbRegoodsBillId.Text = regood.RegoodsBillId.ToString();
                 txbUserId.Text = regood.UserId;
                 txbReGoodsTime.Text = regood.RegoodsTime.ToString();
                 txbReGoodsCustomerId.Text = sell.CustomerID;
                 if (customer != null)
                 {
                     txbReGoodsCustomerName.Text = customer.CustomerName;
                 }
                 txbRegoodsResult.Text = regood.ReGoodResult;


                 //退货服装信息
                 txbRegoodsId.Text = regood.ReGoodsID;
                 txbRegoodsName.Text = good.GoodName;
                 txbRegoodsCategoryName.Text = goodCategory.GoodCategoryName;
                 txbRegoodsStockNum.Text = stockNum.ToString();
                 txbRegoodsPrice.Text = regood.ReGoodsPrice.ToString();
                 txbRegoodsNum.Text = regood.ReGoodsNum.ToString();
                 txbRegoodsNeedPay.Text = regood.ReNeedPay.ToString();
                 txbRegoodsRealPay.Text = regood.ReRealPay.ToString();
                 
             }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            this.Close();
        }
    }
}
