﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ClothesSys.BLL;
using ClothesSys.Common;
using ClothesSys.Model;
using ClothesSys.UC;

namespace ClothesSys.FormSaleManage
{
    public partial class FormGoodSell : Form
    {
        ucGoodSellManage ucGSM;
        List<Sell> list = new List<Sell>();
        BindingList<Sell> bl = new BindingList<Sell>();
        int index;
        string userId;
        public FormGoodSell()
        {
            InitializeComponent();
        }

        public FormGoodSell(string uid,ucGoodSellManage uc)
        {
            InitializeComponent();
            userId = uid;
            ucGSM = uc;
        }

        private void FormGoodSell_Load(object sender, EventArgs e)
        {
            bindCmbGoodCategory();
            bindCmbUser();

            bindDgvSell();
            InitialDgvSell();
            InitialTextBoxes();  //初始化TextBox
            bindTxbCustomerID();
            txbGoodStockNum.Text = StockManager.GetStockNumByGoodId(cmbGoodId.SelectedValue.ToString()).ToString();
        }

        void InitialDgvSell()
        {
            dgvSell.AllowUserToAddRows = false;
            dgvSell.SelectionMode = DataGridViewSelectionMode.FullRowSelect;
            dgvSell.AutoSizeColumnsMode = DataGridViewAutoSizeColumnsMode.Fill;
            dgvSell.Columns["sellId"].Visible = false;
            dgvSell.Columns["userId"].Visible = false;
            dgvSell.Columns["goodsId"].HeaderText = "服装ID";
            dgvSell.Columns["goodsId"].DisplayIndex = 0;
            dgvSell.Columns["goodsPrice"].HeaderText = "单价";
            dgvSell.Columns["sellNum"].HeaderText = "销量";
            dgvSell.Columns["needPay"].HeaderText = "应付金额";
            dgvSell.Columns["realPay"].HeaderText = "支付金额";
            dgvSell.Columns["customerId"].Visible = false;
            dgvSell.Columns["sellTime"].Visible = false;
            dgvSell.Columns["remark"].Visible = false;
            dgvSell.Columns["goodsSpecID"].Visible = false;
            
        }

        void InitialTextBoxes()
        {
            txbGoodPrice.Text = "";
            txbNeedPay.Text = "";
            txbSellNum.Text = "";
            txbRealPay.Text = "";
            txbRemark.Text = "无";
            
 
        }

        void bindTxbCustomerID()
        {
            var source = new AutoCompleteStringCollection();


            txbCustomerID.AutoCompleteCustomSource.AddRange(CustomerManager.GetCustomersId());
            txbCustomerID.AutoCompleteSource = AutoCompleteSource.CustomSource;
            txbCustomerID.AutoCompleteMode = AutoCompleteMode.SuggestAppend;
            txbCustomerID.ReadOnly = true;

        }

        

        void bindCmbGoodCategory()
        {
            cmbGoodCategory.DataSource = GoodCategoryManager.GetAllGoodCategoryOfTable();
            cmbGoodCategory.DisplayMember = "GoodCategoryName";
            cmbGoodCategory.ValueMember = "GoodCategoryId";
            cmbGoodCategory.SelectedIndex = 0;
            string cid = cmbGoodCategory.SelectedValue.ToString();
            bindCmbGoodId(cid);
            bindCmbGoodName(cid);
        }

        void bindCmbGoodId(string cid)
        {
            
            cmbGoodId.DataSource = GoodManager.GetGoodsByCategoryId(cid);
            cmbGoodId.DisplayMember = "GoodId";
            cmbGoodId.ValueMember = "GoodId";
            cmbGoodId.AutoCompleteSource = AutoCompleteSource.ListItems;
            cmbGoodId.AutoCompleteMode = AutoCompleteMode.Suggest;
        }

        void bindCmbGoodName(string cid)
        {
            
            cmbGoodName.DataSource = GoodManager.GetGoodsByCategoryId(cid);
            cmbGoodName.DisplayMember = "goodName";
            cmbGoodName.ValueMember = "goodId";
            cmbGoodName.AutoCompleteSource = AutoCompleteSource.ListItems;
            cmbGoodName.AutoCompleteMode = AutoCompleteMode.Suggest;
 
        }

        private void cmbGoodCategory_DropDownClosed(object sender, EventArgs e)
        {
            string cid = cmbGoodCategory.SelectedValue.ToString();
            bindCmbGoodId(cid);
            bindCmbGoodName(cid);
        }

        private void cmbGoodId_DropDownClosed(object sender, EventArgs e)
        {
            string gid = cmbGoodId.SelectedValue.ToString();
            cmbGoodName.SelectedValue = gid;
            txbGoodStockNum.Text = StockManager.GetStockNumByGoodId(gid).ToString();
            
        }

        private void cmbGoodName_DropDownClosed(object sender, EventArgs e)
        {
            string gid = cmbGoodName.SelectedValue.ToString();
            cmbGoodId.SelectedValue = gid;
            txbGoodStockNum.Text = StockManager.GetStockNumByGoodId(gid).ToString();
        }

        private void cbIsCustomer_CheckedChanged(object sender, EventArgs e)
        {
            if (cbIsCustomer.Checked)
            {
                txbCustomerID.ReadOnly = false;
                cmbCustomer.Enabled = true;
                bindCmbCustomer();
            }
            else
            {
                cmbCustomer.Text = "";
                cmbCustomer.Enabled = false;
                txbCustomerID.Text = "";
                txbCustomerID.ReadOnly = true;
            }

        }

        void bindCmbCustomer()
        {
            cmbCustomer.DataSource = CustomerManager.GetAllCustomersOfTable();
            
            cmbCustomer.DisplayMember = "CustomerName";
            cmbCustomer.ValueMember = "CustomerId";
            
            cmbCustomer.SelectedIndex = 0;
            txbCustomerID.Text = cmbCustomer.SelectedValue.ToString();
            
        }

        void bindCmbUser()
        {
            cmbUser.DataSource = UserManager.GetAllUsersOfTable();
            cmbUser.DisplayMember = "Name";
            cmbUser.ValueMember = "UserId";
            cmbUser.SelectedValue = userId;
        }

        
        private void btnAddToSell_Click(object sender, EventArgs e)
        {
            bool f = CommonUtility.ValidateTexbBoxesEmpty(groupBox2.Controls);
            if (f)
            {
                Sell sell = new Sell();


                sell.SellID = SellManager.GetSellId();
                sell.GoodsId = cmbGoodId.SelectedValue.ToString();
                sell.GoodsPrice = Convert.ToInt32(txbGoodPrice.Text);
                sell.SellNum = Convert.ToInt32(txbSellNum.Text);
                sell.NeedPay = Convert.ToInt32(txbNeedPay.Text);
                sell.RealPay = Convert.ToInt32(txbRealPay.Text);
                
                sell.Remark = txbRemark.Text;
                int stockNum = Convert.ToInt32(txbGoodStockNum.Text);
                
                if (sell.SellNum < stockNum)
                {
                    list.Add(sell);

                    bl.Add(sell);  //添加到BindingList中,动态显示到dgvSell
                    //bindDgvSell();
                    txbGoodStockNum.Text = (stockNum - sell.SellNum).ToString();
                }
                else
                {
                    MessageBox.Show("库存不足!无法添加!", "提示");
                }

                InitialTextBoxes();
            }
            else
            {
                MessageBox.Show("请填写完整信息!", "提示");
            }
            

            

        }

        void bindDgvSell()
        {
            dgvSell.DataSource = bl;
                        
        }

        

        private void dgvSell_CellEnter(object sender, DataGridViewCellEventArgs e)
        {
            if (e.RowIndex >= 0)
            {
                index = e.RowIndex;
 
            }
        }

        private void btnSellSubmit_Click(object sender, EventArgs e)
        {
            if (list.Count > 0)
            {
                
                DateTime dt = DateTime.Now;
                string custermerId;
                string userId = cmbUser.SelectedValue.ToString();
                if (cbIsCustomer.Checked&&cmbCustomer.SelectedValue!=null)
                {
                    custermerId = cmbCustomer.SelectedValue.ToString();
                }
                else
                {
                    custermerId = "临时顾客";
                }


                foreach (Sell sell in list)
                {
                    sell.UserID = userId;
                    
                    sell.SellTime = dt;
                    sell.CustomerID = custermerId;
                }

                bool f = SellManager.AddSells(list);
                if (f)
                {
                    MessageBox.Show("提交订单成功!", "提示");
                    this.Close();
                    ucGSM.bindDgvSellRecordToday();
                }
            }
            else
            {
                MessageBox.Show("还没有消费记录!", "提示");
 
            }
        }

        private void txbSellNum_TextChanged(object sender, EventArgs e)
        {
            if (txbGoodPrice.Text != "" && txbSellNum.Text != "")
            {
                int goodPrice = Convert.ToInt32(txbGoodPrice.Text);
                int sellNum = Convert.ToInt32(txbSellNum.Text);
                int needPay = goodPrice * sellNum;
                txbNeedPay.Text = needPay.ToString();
                
            }
        }

        private void txbGoodPrice_TextChanged(object sender, EventArgs e)
        {
            if (txbGoodPrice.Text != "" && txbSellNum.Text != "")
            {
                int goodPrice = Convert.ToInt32(txbGoodPrice.Text);
                int sellNum = Convert.ToInt32(txbSellNum.Text);
                int needPay = goodPrice * sellNum;
                txbNeedPay.Text = needPay.ToString();
            }

        }

        private void txbCustomerID_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Enter)
            {
                //cmbCustomer.ResetText();
                string customerId = txbCustomerID.Text;
                if (CustomerManager.GetCustomerById(customerId).CustomerID != null)
                {
                    
                    cmbCustomer.SelectedValue = customerId;
                    
                }
                else
                {
                    cmbCustomer.SelectedIndex = -1;                   
                }

            }
        }

        private void cmbCustomer_DropDownClosed(object sender, EventArgs e)
        {
            txbCustomerID.Text = cmbCustomer.SelectedValue.ToString();
        }

        

        private void cmbGoodId_KeyDown(object sender, KeyEventArgs e)
        {
            
            if (e.KeyCode == Keys.Enter)
            {
                if (cmbGoodId.SelectedValue != null)
                {
                    
                    cmbGoodName.SelectedValue = cmbGoodId.SelectedValue;
                }
                else
                {
                    cmbGoodName.Text = "查无此项";
                }
 
            }
        }

        private void cmbGoodName_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Enter)
            {
                if (cmbGoodName.SelectedValue != null)
                {
                    cmbGoodId.SelectedValue = cmbGoodName.SelectedValue;
                }
                else
                {
                    cmbGoodId.Text = "查无此项";
                }

            }
        }

        private void btnResetSell_Click(object sender, EventArgs e)
        {
            InitialTextBoxes();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void btnDeleteSell_Click(object sender, EventArgs e)
        {
            if (list.Count > 0)
            {
                list.RemoveAt(index);
                bl.RemoveAt(index);
            }
            else
            {
                MessageBox.Show("没有服装可以删除!","提示");
            }

        }

        private void cmbGoodId_SelectedIndexChanged(object sender, EventArgs e)
        {
            txbGoodStockNum.Text = StockManager.GetStockNumByGoodId(cmbGoodId.SelectedValue.ToString()).ToString();
        }

        private void txbGoodPrice_KeyPress(object sender, KeyPressEventArgs e)
        {
            CommonUtility.ValidateNumber(e);
        }

        private void txbSellNum_KeyPress(object sender, KeyPressEventArgs e)
        {
            CommonUtility.ValidateNumber(e);
        }

        private void txbRealPay_KeyPress(object sender, KeyPressEventArgs e)
        {
            CommonUtility.ValidateNumber(e);
        }

        
    }
}
