﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ClothesSys.BLL;
using ClothesSys.Model;
using ClothesSys.Common;

namespace ClothesSys.FormSaleManage
{
    public partial class FormSellDetail : Form
    {
        string sellId;
        public FormSellDetail(string sid)
        {
            InitializeComponent();
            sellId = sid;
        }

        private void FormSellDetail_Load(object sender, EventArgs e)
        {
            InitialTextBox();
            bindTextBox();
        }

        private void InitialTextBox()
        {
            CommonUtility.SetAllTextBoxReadOnly(this.groupBox1.Controls);
            CommonUtility.SetAllTextBoxReadOnly(this.groupBox2.Controls);
            CommonUtility.SetAllTextBoxReadOnly(this.groupBox3.Controls);
        }

        private void bindTextBox()
        {
            Sell sell = SellManager.GetSellBySellID(sellId);
            Bill bill = BillManager.GetBillBySellId(sellId);
            int stockNum = StockManager.GetStockNumByGoodId(sell.GoodsId);
            Good good = GoodManager.GetGoodById(sell.GoodsId);
            GoodCategory goodCategory = GoodCategoryManager.GetCategoryByCategoryId(good.CategoryID.ToString());
            
            Customer customer = CustomerManager.GetCustomerById(sell.CustomerID);

            //订单信息
            txbBillId.Text = bill.BillId;
            txbBillTime.Text = bill.BillTime.ToString();
            txbUserId.Text = bill.UserId;
            txbRemark.Text = sell.Remark;

            //服装信息
            txbGoodId.Text = sell.GoodsId;
            txbGoodCategoryName.Text = goodCategory.GoodCategoryName;
            txbGoodName.Text = good.GoodName;
            txbStockNum.Text = stockNum.ToString();
            txbGoodPrice.Text = sell.GoodsPrice.ToString();
            txbSellNum.Text = sell.SellNum.ToString();
            txbNeedPay.Text = sell.NeedPay.ToString();
            txbRealPay.Text = sell.RealPay.ToString();

            //顾客信息
            if (customer != null)
            {
                txbCustomerId.Text = customer.CustomerID;
                txbCustomerName.Text = customer.CustomerName;
                txbCustomerScore.Text = customer.Socre.ToString();
            }
            else
            {
                txbCustomerId.Text = "临时顾客";
 
            }
            

            
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            this.Close();
        }


    }
}
